/***************************************************************************
                          dokvokDialog.h  -  description
                             -------------------
    begin                : Wed Jan 12 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOKVOKDIALOG_H
#define DOKVOKDIALOG_H

#include <qgroupbox.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include "vdialog.h"

/**
  *@author Friedrich W. H. Kossebau
  */

class DokVokDialog : public VDialog  {
   Q_OBJECT
  public: 
  	DokVokDialog(QWidget *parent=0, const char *name=0);
  	~DokVokDialog();
    /** opens the dialog and returns true if anything was modified 
      * TODO: if anything is default it will be selected to have quick deleting
      */
    bool wasModified( QString StandardDirectory, bool AutoLoadLastFile );
    /** returns the comment */
    QString standardDirectory() { return DirectoryEdit.text(); };
    /** returns the state of AutoLoadLastFile*/
    bool autoLoadLastFile() { return AutoLoadLastFileCheck.isChecked(); };

  protected: 
    /** sets the layout */
    void setLayout();
  protected: 
    // general box
  	QGroupBox General;
    QVBoxLayout GeneralLayout;
    QHBoxLayout DirectoryLayout;
  	QLineEdit DirectoryEdit;
    QLabel DirectoryLabel;
  	QPushButton Select;
  	QCheckBox AutoLoadLastFileCheck;
  	  
  protected slots:
    void slotDirectorySelect();

  private: 
};

#endif
