/***************************************************************************
                          vdialog.cpp  -  description
                             -------------------
    begin                : Tue Mar 21 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include "vdialog.h"


VDialog::VDialog( QWidget *parent=0, const char *name=0, bool modal = true ) 
  : QDialog( parent, name, modal ),
    Layout( this, 10 ),
    ButtonRow( this )
{

}



VDialog::~VDialog()
{
}


/** sets the layout */
void VDialog::finishLayout()
{
  // to separate the buttonrow
  Layout.addSpacing( 10 );   
  Layout.addStretch( 1 );
	Layout.addWidget( &ButtonRow, 0, AlignBottom );
  
  // buttonrow at bottom of Window
	ButtonRow.addStretch(); // push buttons to the right side
	Ok = ButtonRow.addButton( i18n("&Ok") );
	Cancel = ButtonRow.addButton( i18n("&Cancel") );
	ButtonRow.layout();
			  
  // finally set the arrangment
  Layout.activate();
  
  // power to the buttons  
  connect( Ok, SIGNAL(clicked()), SLOT(accept()) );
  connect( Cancel, SIGNAL(clicked()), SLOT(reject()) );
  
  // set Inputdefaults
  Ok->setDefault(true);
  
  // yes, all should be able to be default
  Ok->setAutoDefault(true);
}
