/***************************************************************************
                          VListDialog.cpp  -  description
                             -------------------
    begin                : Tue Jan 4 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <kquickhelp.h>

#include "vlistdialog.h"

VListDialog::VListDialog(QWidget *parent, const char *name)
  : VDialog(parent,name,true),
    // the general block
    General( this ),
    GeneralLayout( &General, 6, 2, 10 ),
    TitelEdit( &General ),
    TitelLabel( &TitelEdit, i18n("&Titel"), &General ),
    TermTitelEdit( &General ),
    TermTitelLabel( &TermTitelEdit, i18n("&1. Column"), &General ),
    TranslationTitelEdit( &General ),
    TranslationTitelLabel( &TranslationTitelEdit, i18n("&2. Column"), &General ),
    TermLanguageBox( 0, &General ),
    TranslationLanguageBox( 0, &General ),
  	
  	// the additional block
    Additional( this ),
    AdditionalLayout( &Additional, 7, 2, 10 ),
    CommentEdit( &Additional ),
    CommentLabel( &CommentEdit, i18n("&Comment"), &Additional ),
    KeyWordsEdit( &Additional ),
    KeyWordsLabel( &KeyWordsEdit, i18n("&Keywords"), &Additional ),
    AuthorEdit( &Additional ),
    AuthorLabel( &AuthorEdit, i18n("&Author"), &Additional )
{  
  setLayout();
  
  
  // set Inputdefaults
  TitelEdit.setFocus();
}


VListDialog::~VListDialog()
{
}


/** sets the layout */
void VListDialog::setLayout()
{
  setCaption( i18n("Properties of the list") );
  
  // the global layout
  Layout.addWidget( &General );
  Layout.addWidget( &Additional, 10 );
  
  // the general box
  General.setTitle( i18n( "General" ) );
  
//  GeneralLayout.addRowSpacing( 0, fontMetrics().height() );
  GeneralLayout.addWidget( &TitelLabel, 1, 0, AlignLeft);
  GeneralLayout.addMultiCellWidget( &TitelEdit, 2,2,0,1 );
  GeneralLayout.addWidget( &TermTitelLabel, 3, 0, AlignLeft );
  GeneralLayout.addWidget( &TermTitelEdit, 4, 0 );
  GeneralLayout.addWidget( &TranslationTitelLabel, 3, 1, AlignLeft );
  GeneralLayout.addWidget( &TranslationTitelEdit, 4, 1 );
  GeneralLayout.addWidget( &TermLanguageBox, 5, 0 );
  GeneralLayout.addWidget( &TranslationLanguageBox, 5, 1 );
  
/*  KQuickHelp::add( &General, 
    i18n("Here a comment can be given\nto have some information about the list.\n\nAs you may have noticed,\nthis is displayed in the windowtitel.\n\n" \
         "The two columns and the author can also be named."));
*/
    // the titel edit
    TitelEdit.setFixedHeight( TitelEdit.sizeHint().height() );
    TitelEdit.setMinimumWidth( TitelEdit.sizeHint().width() );
    TitelLabel.setFixedSize( TitelLabel.sizeHint() );
    
    // the term titel edit
    TermTitelEdit.setFixedHeight( TermTitelEdit.sizeHint().height() );
    TermTitelLabel.setFixedSize( TermTitelLabel.sizeHint() );
    
    // the translation column edit
    TranslationTitelEdit.setFixedHeight( TranslationTitelEdit.sizeHint().height() );
    TranslationTitelLabel.setFixedSize( TranslationTitelLabel.sizeHint() );
    
    // the language selection
    TermLanguageBox.setMinimumSize( TermLanguageBox.sizeHint() );
    TranslationLanguageBox.setMinimumSize( TranslationLanguageBox.sizeHint() );
  
  GeneralLayout.activate();

  // the additional box
  Additional.setTitle( i18n( "Additional" ) );
  
//TODO: fix distance setting to upper border and the boxtitel
//  AdditionalLayout.addRowSpacing( 0, fontMetrics().height() ); 
  AdditionalLayout.addWidget( &CommentLabel, 1, 0, AlignLeft);
  AdditionalLayout.addMultiCellWidget( &CommentEdit, 2, 2, 0, 1 );
  AdditionalLayout.setRowStretch( 2, 1 );
  AdditionalLayout.addWidget( &KeyWordsLabel, 3, 0, AlignLeft );
  AdditionalLayout.addMultiCellWidget( &KeyWordsEdit, 4,4,0,1 );
  AdditionalLayout.addWidget( &AuthorLabel, 5, 0, AlignLeft );
  AdditionalLayout.addMultiCellWidget( &AuthorEdit, 6,6,0,1 );  
  
    // the comment edit
    QFontMetrics CEFontMetrics( CommentEdit.fontMetrics() );
    CommentEdit.setMinimumSize( CEFontMetrics.width("0")*24, CEFontMetrics.lineSpacing()*3);
    CommentLabel.setFixedSize( CommentLabel.sizeHint() );
    
    // the keywords edit
    KeyWordsEdit.setFixedHeight( KeyWordsEdit.sizeHint().height() );
    KeyWordsLabel.setFixedSize( KeyWordsLabel.sizeHint() );
       
    // the author edit
    AuthorEdit.setFixedHeight( AuthorEdit.sizeHint().height() );
    AuthorLabel.setFixedSize( AuthorLabel.sizeHint() );
       
  AdditionalLayout.activate();
  
  finishLayout();
}

/** opens the dialog and returns true if anything was modified 
  * TODO: if anything is default it will be selected to have quick deleting
  */
bool VListDialog::wasModified( const QString &Titel, 
                                const QString &TermTitel, const QString &TranslationTitel, 
                                const QString &TermLanguage, const QString &TranslationLanguage, 
                                const QString &Comment, const QString &KeyWords, const QString &Author )
{
  TitelEdit.setText( Titel );
  TermTitelEdit.setText( TermTitel );
  TranslationTitelEdit.setText( TranslationTitel );
  CommentEdit.setText( Comment );
  KeyWordsEdit.setText( KeyWords );
  AuthorEdit.setText( Author );
  
  VLanguageList *LanguageList = new VLanguageList();
  TermLanguageBox.fill( LanguageList );
  TermLanguageBox.setLanguage( TermLanguage );
  
  TranslationLanguageBox.fill( LanguageList );
  TranslationLanguageBox.setLanguage( TranslationLanguage );
  
  
/*  if( Comment == i18n("no comment") ) 
    CommentEdit.selectAll(); 
  if( TermColumnTitel == i18n("Term") ) 
    TermColumnEdit.selectAll();
  if( TranslationColumnTitel == i18n("Translation") ) 
    TranslationColumnEdit.selectAll();
  if( Author == i18n("Author") ) 
    AuthorEdit.selectAll();
    
didn't work; seems there can only be one text marked at the same time
*/    
  
  return exec(); 
}
