/***************************************************************************
                          vlangfile.h  -  description
                             -------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VLANGFILE_H
#define VLANGFILE_H

#include <ksimpleconfig.h>

struct VTypInfoList;

/**handles the read of the language config file
  *@author Friedrich W. H. Kossebau
  */

class VLanguageFile 
{
  public: 
  	VLanguageFile( QString Language, bool ReadOnly = true );
	  ~VLanguageFile();
	  
    QString name();
    QFont font();
    VTypInfoList typInfoList();
    
    void writeName( const QString &Name );
    void writeFont( const QFont &Font );
    void writeTypInfoList( VTypInfoList &List );
    
    void writeFile();
    
  protected:
    KSimpleConfig *LanguageFile;
};

#endif
