/***************************************************************************
                          vvokfile.h  -  description
                             -------------------
    begin                : Wed Feb 9 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VVOKFILE_H
#define VVOKFILE_H

#include <qstring.h>
#include <qtextstream.h>
#include <qdict.h>
#include <qfile.h>
#include <qstrlist.h>

class VVocabulary;

/** An io-handler for the vocabulary files. Works similar to the config files
  * who were basics for this
  *
  * @author Friedrich W. H. Kossebau
  */

typedef QDict<QString> VEntryDict;
typedef QDict<VEntryDict> VGroupDict;

typedef QDictIterator<QString> VEntryIterator;
typedef QDictIterator<VEntryDict> VGroupIterator;
  

class VVokFile {
  private:
    QString Group;
    VGroupDict GroupDict;
    QFile File;
    
  public: 
  	VVokFile();
  	~VVokFile();
    /**  */
    bool isWriteable( const QString &Filename );
    /**  */
    void write( VVocabulary *Vocabulary );
  	
    /**  */
    bool isReadable( const QString &Filename );
    /**  */
    void readExtraData( VVocabulary *Vocabulary );
    /**  */
    void readData( VVocabulary *Vocabulary );
    
    void close();
    void clear();
    
    void setGroup( const char* NewGroup );
  
    const char* group() const;
    /**
  	* Read the value of an entry specified by rKey in the current group
  	*
  	* @param pKey	The key to search for.
  	* @param pDefault A default value returned if the key was not found.
  	* @return The value for this key or an empty string if no value
  	*	  was found.
  	*/
    const QString readEntry( const char* Key,
  						 const char* Default = 0L ) const;
  
    /**
  	* Read a list of strings.
  	*
  	* @param pKey The key to search for
  	* @param list In this object, the read list will be returned.
  	* @param sep  The list separator (default ",")
  	* @return The number of entries in the list.
  	*/
    int readListEntry( const char* Key, QStrList &List,
  					 char sep = ',' ) const;
  
    /**
  	* Read a numerical value.
  	*
  	* Read the value of an entry specified by rKey in the current group
  	* and interpret it numerically.
  	*
  	* @param pKey The key to search for.
  	* @param nDefault A default value returned if the key was not found.
  	* @return The value for this key or 0 if no value was found.
  	*/
    int readNumEntry( const char* Key, int Default = 0 ) const;
  
    /**
     * Read a boolean entry.
     *
     * Read the value of an entry specified by pKey in the current group
     * and interpret it as a boolean value. Currently "on" and "true" are
     * accepted as true, everything else if false.
     *
     * @param pKey		The key to search for
     * @param bDefault    A default value returned if the key was not
     * 					found.
     * @return The value for this key or a default value if no value was
     * found.
     */
    bool readBoolEntry( const char* Key, const bool Default = false ) const;
  
    void writeEntry( const char* Key, const char* Value );
    
    bool hasKey( const char* Key ) const;
  
};

#endif
