/***************************************************************************
                          dokvokdoc.cpp  -  description
                             -------------------
    begin                : Son Dez 19 13:14:00 CET 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qlist.h>
#include <qstring.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include "dokvokdoc.h"
#include "dokvok.h"
#include "View/dokvokview.h"
#include "resource.h"
#include "Dialoge/vlistdialog.h"
#include "Abfrage/vquestdialog.h"
#include "Dialoge/vlangdialog.h"

#include <iostream.h>

QList<DokVokView> *DokVokDoc::allViewsList = 0L;

DokVokDoc::DokVokDoc(QWidget *parent, const char *name) 
  : VVocabulary(parent, name),
    VokFile(),
    AbsoluteDirName(),
    FileName()
{
	if( !allViewsList )	allViewsList = new QList<DokVokView>;
	sameViewsList = new QList<DokVokView>;

	QuestionSettings = new VQuestionSettings();
 
  connect( QApplication::clipboard(),SIGNAL( dataChanged() ), SLOT( clipboardChanged() ) );
}


DokVokDoc::~DokVokDoc()
{
}

void DokVokDoc::addView(DokVokView *NewView)
{
  View = NewView;
  allViewsList->append( View );
	sameViewsList->append( View );
  connect( this, SIGNAL( newColumnTitel(int,const char*) ), View, SLOT( setColumnTitel(int,const char*) ) );
  connect( this, SIGNAL( newLanguage(int,const char*) ), View, SLOT( setLanguage(int,const char*) ) );
  connect( View, SIGNAL( clipboardHasData(bool) ), SLOT( setPasteFromClipboard(bool) ) );
  connect( View, SIGNAL( newTypInfoList(VTypInfoList*) ), SLOT( setTypInfoList(VTypInfoList*) ) );

	resetView( View );
}


void DokVokDoc::removeView(DokVokView *View)
{
  allViewsList->remove(View);
	sameViewsList->remove(View);
}
  	  	

void DokVokDoc::slotUpdateAllViews(DokVokView *sender)
{
  DokVokView *w;
  if(allViewsList)
  {
    for(w=allViewsList->first(); w!=0; w=allViewsList->next())
    {
      if(w!=sender)
        w->repaint();
    }
  }
}


void DokVokDoc::closeDocument()
{
  deleteContents();
}

bool DokVokDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////

  deleteContents();
  setDocumentNew();  
  VokFile.clear();
	
  setTitel( i18n("Untitled") );		
	setComment( i18n("No comment") );
	setKeyWords( "" );
	setAuthor( "" );
	setColumnTitel( TermColumn, i18n("Term") );
	setColumnTitel( TranslationColumn, i18n("Translation") );
	setLanguage( TermColumn, "" );
	setLanguage( TranslationColumn, "" );

	resetAllViews();
	appendVokabel();

	slotSetEditMode( true );
	setModified( false );
	
  return true;
}

bool DokVokDoc::openDocument(const QString &FilePath, const char *format /*=0*/)
{
  if( VokFile.isReadable(FilePath) )
  {
  	//reset the vocabulary
	  clear( true );
    
    // store file name 
    QFileInfo FileInfo( FilePath );
    setAbsoluteDirName( FileInfo.dirPath(true) );	
    setFileName( FileInfo.fileName() );	
    
    // store vocabulary extra data
    VokFile.readExtraData( this );
    
    VokFile.setGroup( "General" );
		setTitel( VokFile.readEntry( "Titel", i18n("Untitled") ) );
		setComment( VokFile.readEntry("Comment", i18n( "No comment" )) );
		setKeyWords( VokFile.readEntry( "KeyWords", "" ) );
		setAuthor( VokFile.readEntry("Author", "") );
		setColumnTitel( TermColumn, VokFile.readEntry("TermTitel", i18n( "Term" )) );
		setColumnTitel( TranslationColumn, VokFile.readEntry("TranslationTitel", i18n( "Translation" )) );
		setLanguage( TermColumn, VokFile.readEntry("TermLanguage", "") );
		setLanguage( TranslationColumn, VokFile.readEntry("TranslationLanguage", "") );
		
		// store vocabulary
    VokFile.readData( this );
    
   	if( isEmpty() ) appendVokabel();
	
   	VokFile.close();
   	
   	// now refresh views
    resetAllViews();
    setModified( false );
    emit editModeHasChanged( false );
    return true; 
  }
  else
    return false;
}

bool DokVokDoc::saveDocument(const QString &FilePath, const char *format /*=0*/)
{
  if( VokFile.isWriteable(FilePath) )
  {
		// prepare extra data
    VokFile.setGroup( "General" );
    VokFile.writeEntry( "Titel", titel() );
    VokFile.writeEntry( "Comment", comment() );
    VokFile.writeEntry( "KeyWords", keyWords() );
  	VokFile.writeEntry( "Author", author() );
  	VokFile.writeEntry( "TermTitel", columnTitel( TermColumn ) );
  	VokFile.writeEntry( "TranslationTitel", columnTitel( TranslationColumn ) );
  	VokFile.writeEntry( "TermLanguage", language( TermColumn ) );
  	VokFile.writeEntry( "TranslationLanguage", language( TranslationColumn ) );
    
  	// writing...
    VokFile.write( this );
  
    VokFile.close();
    
    // set flags
    setModified( false );
    
    return true;
  }
  else
    return false;
}

void DokVokDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////
	
	clear( true );
}


void DokVokDoc::appendVokabel( VVokabel *Vokabel = 0 )
{
	if( !Vokabel ) Vokabel = newVokabel();
	
	DokVokView* w;
	if(sameViewsList)
	{ for( w = sameViewsList->first(); w; w = sameViewsList->next() )
			{w->appendVokabel( Vokabel );	}
	}
}


void DokVokDoc::resetView( DokVokView* View )
{
  bool EditMode = View->isEditMode();
	View->hide();
	View->clearVokList();	
	
	VVokabel* Vokabel;
	
	for( Vokabel = first(); Vokabel; Vokabel = next() )
		{ View->appendVokabel( Vokabel, false );	}
	
	View->setColumnTitel( TermColumn, columnTitel(TermColumn) );
	View->setColumnTitel( TranslationColumn, columnTitel(TranslationColumn) );

  View->setLanguage( TermColumn, language(TermColumn) );
  View->setLanguage( TranslationColumn, language(TranslationColumn) );

	View->show();
	slotSetEditMode( EditMode );
}


void DokVokDoc::resetAllViews()
{
	DokVokView* View;
	if(sameViewsList)
	{ for( View = sameViewsList->first(); View; View = sameViewsList->next() )
			resetView( View );
	}
}


/** sets the EditMode */
void DokVokDoc::slotSetEditMode ( bool Editing = true )
{
	DokVokView* w;
	if(sameViewsList)
	{ for( w = sameViewsList->first(); w; w = sameViewsList->next() )
			{w->setEditMode( Editing );	}
	}
	emit editModeHasChanged( Editing );
}


/** sets the modified flag for the document after a modifying action on the view connected to the document.*/
void DokVokDoc::setModified ( bool IsModified = true )
{
//  if( Modified == IsModified ) return; 
  
  Modified = IsModified;
}


/** opens a dialog for editing of the list properties */
void DokVokDoc::editProperties()
{
  VListDialog Dialog;
  
  if( Dialog.wasModified( titel(),
                          columnTitel( TermColumn ),
  												columnTitel( TranslationColumn ),
  												language( TermColumn ),
  												language( TranslationColumn ),
                          comment(),
                          keyWords(),
  												author()                          ) ) 
  {//TODO: each update only if changed
  	setTitel( Dialog.titel() );
  	setColumnTitel( TermColumn, Dialog.termTitel() );
  	setColumnTitel( TranslationColumn, Dialog.translationTitel() );
  	setLanguage( TermColumn, Dialog.termLanguage() );
  	setLanguage( TranslationColumn, Dialog.translationLanguage() );
  	setComment( Dialog.comment() );
  	setKeyWords( Dialog.keyWords() );
  	setAuthor( Dialog.author() );
  	  	
  	setModified();
  };
}

/** set Copy-Mark to Comment*/
void DokVokDoc::setAsCopy()
{
  setTitel( i18n( "Copy of " ) + titel() );
  setDocumentNew();
}


/** sets the filedata to neutral */
void DokVokDoc::setDocumentNew()
{
  DokVokApp *win=(DokVokApp *) parent();
  setAbsoluteDirName( win->getStandardDirectory() );
  setFileName( "" );
}


/** copies the selection depending on the EditMode to the clipboard */
void DokVokDoc::copySelection()
{
  
  if( View->isEditMode() )
    View->copyText();
  else
  {
    QClipboard *Clipboard = QApplication::clipboard();
    QString CopyData;
    
    if( View->hasSelectedItems() )
    {
      VVokabel *Vokabel;
	  	for ( Vokabel=View->firstSelectedVok(); Vokabel; Vokabel=View->nextSelectedVok() )
  	  	CopyData += (line(Vokabel) + "\n");
  	}
  	else
  	  CopyData = line( View->currentVok() ) + "\n";
    
    Clipboard->setText( CopyData );
  }
}


/** sets the typ of the actual or selected vocabels */
void DokVokDoc::setTyp( int Index )
{
  VTyp Typ;
  VTypInfoList *List = View->typInfoList();
  
  Index--;
  if( (Index > -1) && (Index < (int)List->count()) )
    Typ.setSymbol( List->symbol(Index) );
    
  if( View->hasSelectedItems() )
  {
    VVokabel *Vokabel;
  	for ( Vokabel=View->firstSelectedVok(); Vokabel; Vokabel=View->nextSelectedVok() )
	  	Vokabel->setSymbol( Typ.symbol() );
	}
	else
	  View->currentVok()->setSymbol( Typ.symbol() );
}


/** cuts the selection depending on the EditMode */
void DokVokDoc::cutSelection()
{
  
  if( View->isEditMode() )
    View->cutText();
  else
  {
  copySelection();
  deleteSelection();
  }

}

/** deletes the selection depending on the EditMode */
void DokVokDoc::deleteSelection()
{
//  VVokabel *AktuelleVokabel;
//  int Index;

  // delete vocabels in vocabellist based on information from the voclist
  // try to save information for the view after this operation, like currentItem
  if( View->hasSelectedItems() )
  {
//    AktuelleVokabel = View->currentVok();
  
  
    VVokabel *Vokabel;
  	for( Vokabel=View->firstSelectedVok(); Vokabel; Vokabel=View->nextSelectedVok() )
    	removeRef( Vokabel );
  }
  else
  {
//    AktuelleVokabel = View->getCurrentVok();
//    Index = VokabelList.findRef( AktuelleVokabel);
    
//    VVokabel *Vokabel;
//    if( Vokabel = VokabelList.next() )
//      // there is a vocabel following
//      AktuelleVokabel = Vokabel;
//    else if( Vokabel )
    
      
    removeRef( View->currentVok() );
  }
  
  setModified();
  
  // build view and set current and first viewed item close to the prior ones
//  if( Vokabel )
  if( !isEmpty() )
  {
    resetAllViews();
    
//    View->setCurrentVok( Vokabel );
  }
  else
  {
    // all vocabels were killed
    appendVokabel();
    resetAllViews();
  }
}


/** pastes the TODO:inhalt from the clipboard */
void DokVokDoc::pasteFromClipboard()
{
  if( View->isEditMode() )
    View->insertText();
  else
  {
    QClipboard *Clipboard = QApplication::clipboard();
    QString CopyData = Clipboard->text();
    int von = 0;
    int bis = 0;
  
    while( (bis = CopyData.find ( '\n', von )) != -1 )  // as long as there are new line marks
    {
      newVokabel( CopyData.mid( von, bis-von ) );    // vokabeln excluding '\n'
      von = bis + 1;
    }
    
    if( (bis = CopyData.length()) != von )
 	  	newVokabel( CopyData.mid( von, -von ) );    //line without '\n' left
    resetAllViews();
  }

  
}

/** tests if clipboard has Data and emits the state */
void DokVokDoc::clipboardChanged()
{
  QString text=QApplication::clipboard()->text();
  emit clipboardHasData( !text.isEmpty() );
}


/** */
void DokVokDoc::learning()
{
 
 // no need to delete, this is done by VAbfrageDialog
 VVokabelList *LearnList = new VVokabelList; 
 VVokabel *Vokabel;
 
 if( View->hasSelectedItems() )  // only selected items should be asked?
   {
    for( Vokabel = View->firstSelectedVok(); Vokabel; Vokabel = View->nextSelectedVok() )
      if( !Vokabel->string(TermColumn).isEmpty() ) LearnList->inSort( Vokabel );
   }
 else
   {
    for( Vokabel = first(); Vokabel; Vokabel = next() )
      if( !Vokabel->string(TermColumn).isEmpty() ) LearnList->inSort( Vokabel );
   }
 
 VAbfrageDialog *Dialog = new VAbfrageDialog( LearnList, 
                             language(TermColumn), language(TranslationColumn), QuestionSettings );
 
 View->hide();
 
 if( Dialog->learn() ) setModified();
 
 View->show();
}



/** reads all Settings from the config file */
void DokVokDoc::readQuestionSettings( KConfig *Config )
{
  // partial knowledge accepted?
  QuestionSettings->CheckerSettings.Partial = Config->readBoolEntry( "Partial", false );
  // should the corrected input be shown at the second chance?
  QuestionSettings->ShowCorrectedInput = Config->readBoolEntry( "Show Corrected Input", true );
  
  // should there be a second chance?
  QuestionSettings->SecondChance = Config->readBoolEntry( "Second Chance", false );
  // what character to use for unknown characters?
  QuestionSettings->CheckerSettings.UnknownCharacter = Config->readEntry( "Unknown Character", "" )[0];
}



/** writes all Settings from the config file */
void DokVokDoc::writeQuestionSettings( KConfig *Config )
{
  Config->writeEntry( "Partial", QuestionSettings->CheckerSettings.Partial );
  Config->writeEntry( "Show Corrected Input", QuestionSettings->ShowCorrectedInput );
  
  Config->writeEntry( "Second Chance", QuestionSettings->SecondChance );
  Config->writeEntry( "Unknown Character", &QuestionSettings->CheckerSettings.UnknownCharacter );
}


/** opens a dialog for editing of the list properties */
void DokVokDoc::editQuestionSettings()
{
  VQuestionDialog Dialog;
  
  Dialog.edit( QuestionSettings );
}


/** opens a dialog for editing of the list properties */
void DokVokDoc::editLanguages()
{
  VLanguagesDialog Dialog;
  
  Dialog.edit();
  
  setLanguage( TermColumn, language( TermColumn ) );
  setLanguage( TranslationColumn, language( TranslationColumn ) );
}



/** */
void DokVokDoc::setTypInfoList( VTypInfoList *TypInfoList )
{
  emit newTypInfoList( TypInfoList );
}