/***************************************************************************
                          vvocabulary.cpp  -  description
                             -------------------
    begin                : Wed Mar 15 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>

#include "vvocabulary.h"

VVocabulary::VVocabulary(QObject * parent=0, const char * name=0) : QObject( parent, name )
{
  clear();
}


VVocabulary::~VVocabulary()
{
}



/** clears the lists and sets strings to 0 */
void VVocabulary::clear( bool total = false ){

  setAutoDelete( total );
	VVokabelList::clear();
	
	setTitel( "" );
	setColumnTitel( TermColumn, "" );
	setColumnTitel( TranslationColumn, "" );
	setComment( "" );
	setKeyWords( "" );
	setAuthor( "" );
}


/** sets titel of column Column */
void VVocabulary::setLanguage( const int Column, const QString &NewLanguage ) 
{
  Language[Column] = NewLanguage; 
  emit newLanguage( Column, NewLanguage );
}


/** sets titel of column Column */
void VVocabulary::setColumnTitel( const int Column, const char* NewTitel ) 
{
  ColumnTitel[Column] = NewTitel; 
  emit newColumnTitel( Column, NewTitel );
}



/** sets titel of column Column */    
void VVocabulary::setColumnTitel( const int Column, const QString &NewTitel )
{ 
  ColumnTitel[Column] = NewTitel;  
  emit newColumnTitel( Column, NewTitel );
}