/***************************************************************************
          LangPropPage.cpp  -  language properties dialog page
                      -------------------
    begin                : Wed Oct 13 18:37:13 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#define Inherited LangPropPageData

#include "langset.h"
#include "kvoctraindoc.h"
#include "LangPropPage.h"
#include "GrammerManager.h"

#include <kapp.h>

#include <qkeycode.h>

LangPropPage::LangPropPage
(
        kvoctrainDoc      *_doc,
        QString            curr_lang,
        const Conjugation &conjug,
        const Article     &art,
        QWidget           *parent = NULL,
        const char        *name = NULL
)
	:
	Inherited( parent, name ),
        doc(_doc),
        conjugations(conjug),
        articles(art)
{
   setCaption(i18n("language properties" ));
   conjugations = conjug;

   first_plural->setText (conjugations.pers1Plural (CONJ_PREFIX));
   first_singular->setText (conjugations.pers1Singular (CONJ_PREFIX));
   second_singular->setText (conjugations.pers2Singular (CONJ_PREFIX));
   second_plural->setText (conjugations.pers2Plural (CONJ_PREFIX));
   thirdF_plural->setText (conjugations.pers3FemalePlural (CONJ_PREFIX));
   thirdF_singular->setText (conjugations.pers3FemaleSingular (CONJ_PREFIX));
   thirdN_plural->setText (conjugations.pers3NaturalPlural (CONJ_PREFIX));
   thirdN_singular->setText (conjugations.pers3NaturalSingular (CONJ_PREFIX));
   thirdM_plural->setText (conjugations.pers3MalePlural (CONJ_PREFIX));
   thirdM_singular->setText (conjugations.pers3MaleSingular (CONJ_PREFIX));

   bool common = conjugations.pers3SingularCommon(CONJ_PREFIX);
   thirdS_common->setChecked(common);
   thirdM_singular->setEnabled(!common);
   thirdN_singular->setEnabled(!common);

   common = conjugations.pers3PluralCommon(CONJ_PREFIX);
   thirdP_common->setChecked(common);
   thirdN_plural->setEnabled(!common);
   thirdM_plural->setEnabled(!common);

   female_label->setBuddy (def_female);
   male_label->setBuddy (def_male);
   natural_label->setBuddy (def_natural);

   female_c_label->setBuddy (thirdF_singular);
   male_c_label->setBuddy (thirdM_singular);
   natural_c_label->setBuddy (thirdN_singular);

   pers1_label->setBuddy(first_singular);
   pers2_label->setBuddy(second_singular);
   pers3_label->setBuddy(thirdF_singular);

   QString def, indef;
   articles.female(def, indef);
   def_female->setText (def);
   indef_female->setText (indef);

   articles.male(def, indef);
   def_male->setText (def);
   indef_male->setText (indef);

   articles.natural(def, indef);
   def_natural->setText (def);
   indef_natural->setText (indef);
}


void LangPropPage::initFocus() const
{
  def_female->setFocus();
}


Conjugation LangPropPage::getConjugation()
{
  conjugations.cleanUp();
  return conjugations;
}


void LangPropPage::firstPluralChanged(EA_QTSTR s)
{
   conjugations.setPers1Plural (CONJ_PREFIX, s);
}


void LangPropPage::firstSingularChanged(EA_QTSTR s)
{
   conjugations.setPers1Singular (CONJ_PREFIX, s);
}


void LangPropPage::secondSingularChanged(EA_QTSTR s)
{
   conjugations.setPers2Singular (CONJ_PREFIX, s);
}


void LangPropPage::secondPluralChanged(EA_QTSTR s)
{
   conjugations.setPers2Plural (CONJ_PREFIX, s);
}


void LangPropPage::thirdFPluralChanged(EA_QTSTR s)
{
   conjugations.setPers3FemalePlural (CONJ_PREFIX, s);
}


void LangPropPage::thirdFSingularChanged(EA_QTSTR s)
{
   conjugations.setPers3FemaleSingular (CONJ_PREFIX, s);
}


void LangPropPage::thirdMSingularChanged(EA_QTSTR s)
{
   conjugations.setPers3MaleSingular (CONJ_PREFIX, s);
}


void LangPropPage::thirdNSingularChanged(EA_QTSTR s)
{
   conjugations.setPers3NaturalSingular(CONJ_PREFIX, s);
}


void LangPropPage::thirdNPluralChanged(EA_QTSTR s)
{
   conjugations.setPers3NaturalPlural (CONJ_PREFIX, s);
}


void LangPropPage::thirdMPluralChanged(EA_QTSTR s)
{
   conjugations.setPers3MalePlural (CONJ_PREFIX, s);
}


void LangPropPage::slotThirdSCommonToggled(bool common)
{
  conjugations.setPers3SingularCommon(CONJ_PREFIX, common);
  thirdN_singular->setEnabled(!common);
  thirdM_singular->setEnabled(!common);
}


void LangPropPage::slotThirdPCommonToggled(bool common)
{
  conjugations.setPers3PluralCommon(CONJ_PREFIX, common);
  thirdN_plural->setEnabled(!common);
  thirdM_plural->setEnabled(!common);
}


void LangPropPage::defFemaleChanged(EA_QTSTR s)
{
   QString def, indef;
   articles.female(def, indef);
   articles.setFemale(s, indef);
}


void LangPropPage::indefFemaleChanged(EA_QTSTR s)
{
   QString def, indef;
   articles.female(def, indef);
   articles.setFemale(def, s);
}


void LangPropPage::defMaleChanged(EA_QTSTR s)
{
   QString def, indef;
   articles.male(def, indef);
   articles.setMale(s, indef);
}


void LangPropPage::indefMaleChanged(EA_QTSTR s)
{
   QString def, indef;
   articles.male(def, indef);
   articles.setMale(def, s);
}


void LangPropPage::defNaturalChanged(EA_QTSTR s)
{
   QString def, indef;
   articles.natural(def, indef);
   articles.setNatural(s, indef);
}


void LangPropPage::indefNaturalChanged(EA_QTSTR s)
{
   QString def, indef;
   articles.natural(def, indef);
   articles.setNatural(def, s);
}


LangPropPage::~LangPropPage()
{
}


void LangPropPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
