/***************************************************************************
        AdjEntryPage.cpp  -  dialog page for adjectives (comparison)
                          -------------------
    begin                : Sat Dec 4 18:09:29 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef AdjEntryPage_included
#define AdjEntryPage_included

#include "AdjEntryPageData.h"
#include "GrammerManager.h"

class AdjEntryPage : public AdjEntryPageData
{
    Q_OBJECT

public:

    AdjEntryPage
    (
        QDialog           *dlgbook,
        bool               multi_sel,
        const Comparison  &comp,
        QWidget           *parent = NULL,
        const char        *name = NULL
    );

    virtual ~AdjEntryPage();

    Comparison getComparison() const { return comparisons; }

protected:
    void keyPressEvent( QKeyEvent * );

protected slots:
    virtual void initFocus() const;
    virtual void lev1Changed(EA_QTSTR);
    virtual void lev2Changed(EA_QTSTR);
    virtual void lev3Changed(EA_QTSTR);
    virtual void returnPressed();

protected:

    Comparison comparisons;
};
#endif // AdjEntryPage_included
