/***************************************************************************
                    kva_io.cpp  - i/o part of kvoctrain
                             -------------------
    begin                : Thu Mar 11 20:50:53 MET 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kfiledialog.h>
#include <qprogressbar.h>
#include <qfile.h>
#include <qfileinfo.h>

#include "kvoctrain.h"
#include "common-dialogs/ProgressDlg.h"

#define PATTERN_ALL  "*.*"            "|All files (*.*)\n"
#define PATTERN_ML   "*." KVTML_EXT   "|KVoctrain Markup (*.kvtml)\n"
#define PATTERN_BIN  "*." KVTBIN_EXT  "|KVoctrain Binary (*.kvtbin)\n"
#define PATTERN_LEX  "*." VT5_LEX_EXT "|Vocabulary Trainer 5.0 (*.lex)\n"
#define PATTERN_VL   "*." KVL_EXT     "|KVoclearn (*.vl)\n"
#define PATTERN_QVO  "*." QVOCAB_EXT  "|QVocab (*.qvo)\n"
#define PATTERN_CSV  "*." CSV_EXT     "|Text (*.csv)\n"

// we can read these
#define FILTER_RPATTERN  PATTERN_ML PATTERN_BIN PATTERN_CSV PATTERN_LEX PATTERN_ALL

// we can write these
#define FILTER_WPATTERN  PATTERN_ML PATTERN_BIN PATTERN_CSV PATTERN_LEX PATTERN_ALL

#ifdef __ONLY_TO_BE_SEEN_BY_XGETTEXT
 i18n(FILTER_RPATTERN)
 i18n(FILTER_WPATTERN)
#endif


void kvoctrainApp::slotTimeOutBackup() /*FOLD00*/
{
  if (backupTime != 0 && doc && doc->isModified() ) {
    slotStatusMsg(i18n("Autobackup in progress"));
    slotFileSave();
  }
  btimer->start(backupTime, TRUE);
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::aboutToShowFile() { /*FOLD00*/
}


bool kvoctrainApp::queryClose() /*FOLD00*/
{
   bool erg = queryExit();
   if (erg)
     doc->setModified(false);  // avoid double query on exit via system menu
   return erg;
}


bool kvoctrainApp::queryExit() /*FOLD00*/
{
  saveOptions(false);
  if (!doc || !doc->isModified() ) return true;

  if (backupTime != 0) {  // autobackup on: save without asking
    slotFileSave();       // save and exit
    return true;
  }

#ifdef EA_KDE2x
  int exit = KMessageBox::warningYesNoCancel(this, KVOCTRAIN_TITLE,
            i18n("Vocabulary is modified\n\nSave file before exit ?\n"));
  if(exit==KMessageBox::Yes) {
#else
  int exit = KMsgBox::yesNoCancel(this, KVOCTRAIN_TITLE,
            i18n("Vocabulary is modified\n\nSave file before exit ?\n"),
            KMsgBox::DB_FIRST | KMsgBox::QUESTION);
  if(exit==1) {
#endif
    slotFileSave();   // save and exit
    return true;
  }
  else if (exit == 2) {
    return true;     // dont save but exit
  }

  return false;      // continue work
}


void kvoctrainApp::slotFileQuit() /*FOLD00*/
{ 
  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
#ifndef EA_KDE2x
      KTMainWindow::deleteAll();
#endif
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotProgress(kvoctrainDoc *curr_doc, int percent) /*FOLD00*/
{
  if (pbar != 0)
     pbar->setProgress (percent);
  else if (pdlg != 0)
     pdlg->setValue (curr_doc, percent);
   kapp->processEvents();
}


void kvoctrainApp::slotFileOpenRecent(int id_) /*FOLD00*/
{
  slotStatusMsg(i18n("Opening file..."));

  if (queryExit() && recent_files.count() != 0) {
    QString name = recent_files.at(id_);
    if (!name.isEmpty() ) {
      view->setView(0, langset, gradecols);
      delete doc;
      slotStatusMsg(i18n("Loading "+name));
      prepareProgressBar();
      doc = new kvoctrainDoc (this, name, separator, &paste_order);
      removeProgressBar();
      loadDocProps(doc);
      if (!doc->getTitle().isEmpty() )
        setCaption(QString(KVOCTRAIN_TITLE) + ": " + doc->getTitle());
      else
        setCaption(KVOCTRAIN_TITLE);
      addRecentFile(name);
      view->setView(doc, langset, gradecols);
    }
  }
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::addRecentFile(const char* rel_file) /*FOLD00*/
{
  QString file = QFileInfo (rel_file).absFilePath();
  int pos = recent_files.find(file);
  if((pos == -1)){
    if( recent_files.count() < MAX_RECENTFILES)
      recent_files.insert(0,file);
    else{
      recent_files.remove(MAX_RECENTFILES-1);
      recent_files.insert(0,file);
    }
  }
  else {
    recent_files.remove(pos);
    recent_files.insert(0,file);  // make most recent the first entry
  }

  // create the file_open_popup for the toolbar and the menu
  recent_files_menu->clear();
  file_open_popup->clear();
  for ( int i =0 ; i < (int)recent_files.count(); i++){
    recent_files_menu->insertItem(recent_files.at(i));
    file_open_popup->insertItem(recent_files.at(i));
  }
}


void kvoctrainApp::slotFileNew() /*FOLD00*/
{
  slotStatusMsg(i18n("Creating new file..."));

  if (queryExit() ) {
    view->setView (0, langset, gradecols);
    delete doc;

    doc = new kvoctrainDoc (this, "", separator, &paste_order);
    loadDocProps(doc);

    if (doc->numLangs() == 0)
      doc->appendLang("en");
    setCaption(KVOCTRAIN_TITLE);
    view->setView(doc, langset, gradecols);
  }
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotFileOpen() /*FOLD00*/
{
  slotStatusMsg(i18n("Opening file..."));

  if (queryExit() ) {
    QString s;
    if (recent_files.count() > 0)
      s = recent_files.at(0);
    QString name = KFileDialog::getOpenFileName (s, FILTER_RPATTERN, 0,
                    QString(KVOCTRAIN_TITLE) + i18n(": Open file"));
    if (!name.isEmpty() ) {
      view->setView(0, langset, gradecols);
      delete doc;
      slotStatusMsg(i18n("Loading "+name));
      prepareProgressBar();
      doc = new kvoctrainDoc (this, name, separator, &paste_order);
      removeProgressBar();
      loadDocProps(doc);
      if (!doc->getTitle().isEmpty() )
        setCaption(QString(KVOCTRAIN_TITLE) + ": " + doc->getTitle());
      else
        setCaption(KVOCTRAIN_TITLE);
      view->setView(doc, langset, gradecols);
      addRecentFile (name);
    }
  }
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotFileMerge() /*FOLD00*/
{
  slotStatusMsg(i18n("Merging file..."));

  QString s;
  if (recent_files.count() > 0)
    s = recent_files.at(0);
  QString name = KFileDialog::getOpenFileName (s, FILTER_RPATTERN, 0,
                  QString(KVOCTRAIN_TITLE) + i18n(": Merge file"));
  if (!name.isEmpty() ) {
    slotStatusMsg(i18n("Loading "+name));
    prepareProgressBar();
    kvoctrainDoc *new_doc = new kvoctrainDoc (this, name, separator, &paste_order);
    removeProgressBar();

    vector<QString> old_names = doc->getLessonDescr();
    vector<QString> new_names = new_doc->getLessonDescr();

    vector<QString> old_types = doc->getTypeDescr();
    vector<QString> new_types = new_doc->getTypeDescr();

    slotStatusMsg(i18n("Merging "+name));
    QApplication::setOverrideCursor( waitCursor );

    int lesson_offset = lessons->count()-1;
    for (int i = 0; i < (int) new_names.size(); i++) {
      lessons->insertItem (new_names[i]);
      old_names.push_back(new_names[i]);
    }
    doc->setLessonDescr(old_names);

    int types_offset = old_types.size();
    for (int i = 0; i < (int) new_types.size(); i++) {
      old_types.push_back(new_types[i]);
    }
    doc->setTypeDescr(old_types);
    QueryManager::setTypeNames(old_types);

    bool equal = true;
    if (doc->getOriginalIdent() != new_doc->getOriginalIdent())
      equal = false;
    for (int i = 1; i < doc->numLangs(); i++)
      if (doc->getIdent(i) != new_doc->getIdent(i))
        equal = false;

    if (equal) {   // easy way: same language codes, just append
      for (int i = 0; i < new_doc->numEntries(); i++) {
        kvoctrainExpr *expr = new_doc->getEntry(i);

        expr->setLesson(expr->getLesson()+lesson_offset);

        for (int lang = 0; lang <= (int) expr->numTranslations(); lang++) {
          QString t = expr->getType (lang);
          // adjust type offset
          if (!t.isEmpty() && t.left(1) == QM_USER_TYPE) {
            QString t2;
            t.remove (0, 1);
            t2.setNum (t.toInt()+types_offset);
            t2.insert (0, QM_USER_TYPE);
            expr->setType (lang, t2);
          }
        }

        doc->appendEntry (expr);
      }
      doc->setModified();
    }
    else { // hard way: move entries around, most attributes get lost
      vector<int> move_matrix;

      move_matrix.push_back(new_doc->findIdent(doc->getOriginalIdent()));
      for (int i = 1; i < doc->numLangs(); i++)
        move_matrix.push_back(new_doc->findIdent(doc->getIdent(i)));

      for (int i = 0; i < new_doc->numEntries(); i++) {
        kvoctrainExpr new_expr;
        kvoctrainExpr *expr = new_doc->getEntry(i);
        new_expr.setLesson(expr->getLesson()+lesson_offset);

        for (int i = 0; i < (int) move_matrix.size(); i++) {
          int lpos = move_matrix[i];
          if (lpos >= 0) {
            if (lpos == 0)
              s = expr->getOriginal();
            else
              s = expr->getTranslation(lpos);

            if (i == 0)
              new_expr.setOriginal(s);
            else
              new_expr.setTranslation(i, s);
            new_expr.setRemark (i, expr->getRemark(lpos));

            QString t = expr->getType(lpos);
            if (!t.isEmpty() && t.left(1) == QM_USER_TYPE) {
              QString t2;
              t.remove (0, 1);
              t2.setNum (t.toInt()+types_offset);
              t2.insert (0, QM_USER_TYPE);
              new_expr.setType (i, t2);
            }
    
          }
        }
        // only append if entries are used
        bool used = !new_expr.getOriginal().isEmpty();
        for (int i = 1; i < (int) doc->numLangs(); i++)
          if (!new_expr.getTranslation(i).isEmpty())
            used = true;

        if (used) {
          doc->appendEntry(&new_expr);
          doc->setModified();
        }
      }
    }
    delete (new_doc);
    addRecentFile (name);
  }
  view->setView(doc, langset, gradecols);
  view->getTable()->updateViewPort();
  QApplication::restoreOverrideCursor();
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotFileSave() /*FOLD00*/
{
  if (doc->getFileName().isEmpty() ) {
    slotFileSaveAs();
    return;
  }

  slotStatusMsg(i18n("Saving ") + doc->getFileName());

  QFile::remove(doc->getFileName()+"~");   // remove previous backup
  ::rename (doc->getFileName(), doc->getFileName()+"~");

  prepareProgressBar();
  saveDocProps(doc);
  doc->saveAs(this, doc->getFileName(), doc->getTitle(),
              kvoctrainDoc::automatic, separator, &paste_order);
  removeProgressBar();

  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::fillLessonBox(kvoctrainDoc *the_doc)
{
  lessons->clear();
  lessons->insertItem (i18n("<no lesson>"));
  vector<QString> names = the_doc->getLessonDescr();
  for (int i = 0; i < (int) names.size(); i++)
    lessons->insertItem (names[i]);
  act_lesson = the_doc->getCurrentLesson();
  if (act_lesson > lessons->count() ) {
    act_lesson = 0;
    the_doc->setCurrentLesson(act_lesson);
  }
  lessons->setCurrentItem (act_lesson);
}


void kvoctrainApp::loadDocProps(kvoctrainDoc *the_doc) /*FOLD00*/
{
  fillLessonBox(the_doc);

  random_expr1.clear();
  random_expr2.clear();
  queryList.clear();
  the_doc->getQueryLang (act_query_org, act_query_trans);
  if (!act_query_org.isEmpty() && !act_query_trans.isEmpty() ) {
    for (int i = 0; i < the_doc->numEntries(); i++)
      if (the_doc->getEntry(i)->isSelected()) {
        int less = the_doc->getEntry(i)->getLesson();
        for (int l = (int) queryList.size(); l <= less; l++) {
          vector<QueryEntryRef> ref_vec;
          queryList.push_back(ref_vec);
        }
        QueryEntryRef ref(the_doc->getEntry(i), i);
        queryList[less].push_back(ref);
      }
  }

  QueryManager::setTypeNames (doc->getTypeDescr() );

  // remove empty elements
  for (int i = (int) queryList.size()-1; i >= 0; i--)
    if (queryList[i].size() == 0) {
      queryList.erase(&queryList[i], &queryList[i+1]);
    }

  query_cycle = 1;
  query_startnum = 0;
  for (int i = 0; i < (int) queryList.size(); i++)
    query_startnum += queryList[i].size();
  query_num = query_startnum;
}


void kvoctrainApp::saveDocProps(kvoctrainDoc *the_doc) /*FOLD00*/
{
  the_doc->setQueryLang (act_query_org, act_query_trans);
}


void kvoctrainApp::slotFileSaveAs() /*FOLD00*/
{
  slotStatusMsg(i18n("Saving file under new filename..."));

  QString s;
  if (recent_files.count() > 0)
    s = recent_files.at(0);
  QString name = KFileDialog::getSaveFileName (s, FILTER_WPATTERN, 0,
                    QString(KVOCTRAIN_TITLE) + i18n(": Save as.."));
  if (!name.isEmpty() ) {

    QFile file (name);
    if (file.exists() ) {
      QString msg;
      QString format = i18n("Your selected file exists already.\n\n"
                            "Do you want to overwrite %s ?");
#ifndef EA_QT2x
      msg.resize (name.length()+format.length());
#endif
      msg.sprintf ((const char*) format,
                   (const char*) name);

#ifdef EA_KDE2x
      int exit = KMessageBox::warningYesNo(this,
                    QString(KVOCTRAIN_TITLE) +i18n(": File exists"),
                    msg);
      if(exit==KMessageBox::Yes)
#else
      int exit = KMsgBox::yesNo(this,
                 QString(KVOCTRAIN_TITLE) +i18n(": File exists"),
                 msg,
                 KMsgBox::DB_SECOND | KMsgBox::EXCLAMATION);
      if(exit != 1)
#endif
        return;
    }

    if (doc) {
      addRecentFile(name);
      slotStatusMsg(i18n("Saving "+name));
      QFile::remove(name+"~");         // remove previous backup
      ::rename (name, name+"~");
      saveDocProps(doc);

      prepareProgressBar();
      doc->saveAs(this, name, doc->getTitle(),
                  kvoctrainDoc::automatic, separator, &paste_order);
      removeProgressBar();
    }
  }
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotSaveSelection () /*FOLD00*/
{
  if (tagCount == 0)
    return;

  slotStatusMsg(i18n("Saving selected area under new filename..."));

  kvoctrainDoc seldoc(this, "");
  // transfer most important parts
  seldoc.appendLang(doc->getOriginalIdent());
  for (int i = 1; i < doc->numLangs(); i++)
    seldoc.appendLang(doc->getIdent(i));
  seldoc.setAuthor(doc->getAuthor());
  seldoc.setLessonDescr(doc->getLessonDescr());
  seldoc.setTypeDescr(doc->getTypeDescr());

  for (int i = doc->numEntries()-1; i >= 0; i--)
    if (doc->getEntry(i)->isTagged() )
      seldoc.appendEntry(doc->getEntry(i));

  QString s;
  QString name = KFileDialog::getSaveFileName ("", FILTER_WPATTERN, 0,
                    QString(KVOCTRAIN_TITLE) + i18n(": Save block as.."));
  if (!name.isEmpty() ) {

    QFile file (name);
    if (file.exists() ) {
      QString msg;
      QString format = i18n("Your selected file exists already.\n\n"
                            "Do you want to overwrite %s ?");
#ifndef EA_QT2x
      msg.resize (name.length()+format.length());
#endif
      msg.sprintf ((const char*) format,
                   (const char*) name);

#ifdef EA_KDE2x
      int exit = KMessageBox::warningYesNo(this, KVOCTRAIN_TITLE,
                 QString(KVOCTRAIN_TITLE) +i18n(": File exists"));
      if(exit!=KMessageBox::Yes)
#else
      int exit = KMsgBox::yesNo(this,
                 QString(KVOCTRAIN_TITLE) +i18n(": File exists"),
                 msg,
                 KMsgBox::DB_SECOND | KMsgBox::EXCLAMATION);
      if(exit != 1)
#endif
        return;
    }

    slotStatusMsg(i18n("Saving "+name));
    QFile::remove(name+"~");         // remove previous backup
    ::rename (name, name+"~");
    saveDocProps(&seldoc);
 
    prepareProgressBar();
    seldoc.saveAs(this, name, QString (i18n ("Part of: ")) +doc->getTitle(),
                kvoctrainDoc::automatic, separator, &paste_order);
    removeProgressBar();
  }
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::prepareProgressBar () /*FOLD00*/
{
    if (bViewStatusbar) {
      pbar = new QProgressBar (100, statusBar());
      statusBar()->message (pbar);
    }
}


void kvoctrainApp::removeProgressBar () /*FOLD00*/
{
    statusBar()->clear ();
    delete pbar;
    pbar = 0;
    delete pdlg;
    pdlg = 0;
}
