/***************************************************************************
                    kvoctrainview.cpp  - view to kvoctrain parts
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KVOCTRAINVIEW_H 
#define KVOCTRAINVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

class QGridLayout;
class QFrame;
class KHeader;
class KApplication;
class kvoctrainExpr;
class kvoctrainTable;
class kvoctrainApp;
class kvoctrainDoc;
class GradeCols;

#include <qwidget.h>
#include "rowtable.h"
#include "header.h"
#include "kvoctraindoc.h"
#include "langset.h"

/**
  * This class provides an incomplete base for your application view. 
  */

class kvoctrainView : public QWidget
{
  Q_OBJECT

 public:
  /** Constructor for the main view */
  kvoctrainView(KApplication* a,kvoctrainDoc* doc,
                const LangSet &ls, const GradeCols &gradecols,
                kvoctrainApp *parent = 0);

  /** Destructor for the main view */
  ~kvoctrainView();

  /** sets view to another vocabulary */
  void setView (kvoctrainDoc *doc, const LangSet &ls, const GradeCols &gc);

  kvoctrainTable* getTable() { return lb_list; }
  void setHeaderProp (int id, const QString name, const QString pixfile);

  enum Resizer { Automatic, Fixed, Percent};

  void setResizer (Resizer res) { header_resizer = res; }
                                              
  char getHeaderAccel(int i) { return h_list->getHeaderAccel(i); }

 signals:
  void vSliderTrack(int val);
  void vSliderPressed(bool state, int val);

 public slots:

  void slotVSliderChanged (int val);
  void slotVSliderPressed (bool state, int val);

  /** working menu table */
  void popupMenu();

 private:

 protected:

  QFrame          *f_list;
  KHeader         *h_list;
  kvoctrainTable  *lb_list;
  bool             autoResize;
  kvoctrainDoc    *the_doc;
  QGridLayout     *list_layout;
  Resizer          header_resizer;
  kvoctrainApp    *parent;

  /** resizes table when frame is resized */
  virtual void resizeEvent ( QResizeEvent * );

};

/**
  * This class provides a view to your vocabulary
  */

class kvoctrainTable : public RowTable
{
  Q_OBJECT

 public:
  kvoctrainTable( kvoctrainDoc *_doc, const GradeCols *gc = 0,
                  QWidget *parent = NULL, const char *name = NULL );

  void appendItem(kvoctrainExpr *expr);
  void appendCol();
  void removeCurrentItem();
  int  currentItem() { return currentRow(); }
  void setCurrentItem(int row);
  int  count() { return numRows(); }

  void setModified (bool _dirty = true) { m_rows->setModified(_dirty); }
  QString getIdent (int i) const { return m_rows->getIdent(i); }
  QString getOriginalIdent () const { return m_rows->getOriginalIdent(); }
  int findIdent (QString id) const { return m_rows->findIdent(id); }

signals:
  void sigModified();
  void sigCancelSelection();

public slots:
  void sortByColumn (int index);

protected:
  int           current;
};

#endif // KVOCTRAINVIEW_H






















