/***************************************************************************
                 GeneralOptionsDlg.cpp  -  general options dialog class
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "GeneralOptionsDlg.h"
#include "resource.h"
#include <kapp.h>
#include <qcombobox.h>
#include "langset.h"

#define Inherited QTabDialog

#include "compat_2x.h"

class kvoctraindoc;

GeneralOptionsDlg::GeneralOptionsDlg
(
        QString       deflang,
        QString       sep,
        int           btime,
        LangSet      &_langset,
        QString      &lastPix,
        QComboBox    *lessons,
        QStrList     &paste_list,
        kvoctrainDoc *doc,
        QFont        &font,
        QueryManager *manager,
        GradeCols    &gradecols,
        kvoctrainView::Resizer resizer,
        bool          smartAppend,
	QWidget      *parent,
	const char   *name
)
	:
	Inherited( parent, name, true ),
        langset(_langset)
{
  setCaption( QString(KVOCTRAIN_TITLE) + i18n(": General Options") );

  setCancelButton();
  genOptPage =  new GenOptPage  (btime, resizer, smartAppend, this, name);
  langOptPage = new LangOptPage (deflang, langset, lastPix, this, name);
  viewOptPage = new ViewOptPage (font, gradecols, manager, this, name);
  pasteOptPage = new PasteOptPage (sep, langset, paste_list, doc, this, name);

  addTab( genOptPage,  i18n( "&General" ));
  addTab( langOptPage, i18n( "L&anguage" ));
  addTab( viewOptPage, i18n( "&View " ));   // keep SPACE after "View"
  addTab( pasteOptPage, _OptDlg_CLIPBOARD);

  connect (this, SIGNAL(aboutToShow()), genOptPage, SLOT(initFocus() ));
  connect (this, SIGNAL(aboutToShow()), langOptPage, SLOT(initFocus() ));
  connect (this, SIGNAL(aboutToShow()), viewOptPage, SLOT(initFocus() ));
  connect (this, SIGNAL(aboutToShow()), pasteOptPage, SLOT(initFocus() ));

#ifdef EA_QT2x
  connect (this, SIGNAL(selected(const QString&)), pasteOptPage, SLOT(slotSyncLangSet(const QString&)));
#else
  connect (this, SIGNAL(selected(const char*)), pasteOptPage, SLOT(slotSyncLangSet(const char*)));
#endif
  connect( this, SIGNAL(applyButtonPressed()), SLOT(okButton()) );
  connect( this, SIGNAL(cancelButtonPressed()), SLOT(cancelButton()) );

  resize( 520+16,360+76 );
  setMinimumSize( 520+16,360+76 );
  setMaximumSize( 520+16,360+76 );
  setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


GeneralOptionsDlg::~GeneralOptionsDlg()
{
}


void GeneralOptionsDlg::cancelButton()
{
  emit reject();
}


void GeneralOptionsDlg::okButton()
{
  emit accept();
}

