/***************************************************************************
                  VerbQueryDlg.cpp  -  query dialog for verbs
                             -------------------
    begin                : Fri Dec 3 18:28:18 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "VerbQueryDlg.h"
#include "QueryDlg.h"
#include "resource.h"
#include "kvoctraindoc.h"
#include "QueryManager.h"
#include "ProgressChart.h"
#include "kvoctrain.h"
#include "eadebug.h"

#include <kapp.h> 

#include <qtimer.h>
#include <qkeycode.h>

#include <iostream.h>

#include "compat_2x.h"

#define Inherited VerbQueryDlgData


#include <kapp.h>

VerbQueryDlg::VerbQueryDlg
(
	QString type,
        int entry,
        int col,
        int query_cycle,
        int query_num,
        int query_startnum,
        kvoctrainExpr *exp,
        kvoctrainApp  *kv_app,
        kvoctrainDoc  *doc,
        const Conjugation &prefix,
        const Conjugation &conjug,
        int mtime,
        QWidget *parent,
        char *name
)
	:
	Inherited( parent, name )
{
        qtimer = 0;
        setCaption (QString(KVOCTRAIN_TITLE) + ": " + i18n("Training with verbs"));
        setQuery (type, entry, col,
                  query_cycle, query_num, query_startnum,
                  exp, kv_app, doc, prefix, conjug, mtime);
        setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


void VerbQueryDlg::initFocus() const
{
  p1sField->setFocus();
}


void VerbQueryDlg::setQuery(QString type,
                            int entry,
                            int col,
                            int q_cycle,
                            int q_num,
                            int q_start,
                            kvoctrainExpr *exp,
                            kvoctrainApp  *app,
                            kvoctrainDoc  *doc,
                            const Conjugation &prefix,
                            const Conjugation &conjug,
                            int mtime)
{
   kv_app = app;
   kv_doc = doc;
   kv_exp = exp;
   q_row = entry;
   q_ocol = col;
   query_time = mtime;
   showCounter = 0;
   show_all->setDefault(true);
   QString s;
   s.setNum (q_cycle);
   progCount->setText (s);
   progChart->setData (q_start, q_num);
   progChart->repaint();

   conjugations = conjug;
   current = 0;

   p1sLabel->setText  (QString("&1: ")+prefix.pers1Singular(CONJ_PREFIX));
   p2sLabel->setText  (QString("&2: ")+prefix.pers2Singular(CONJ_PREFIX));
   p3sfLabel->setText (QString("&3: ")+prefix.pers3FemaleSingular(CONJ_PREFIX));
   p3smLabel->setText (QString("&4: ")+prefix.pers3MaleSingular(CONJ_PREFIX));
   p3snLabel->setText (QString("&5: ")+prefix.pers3NaturalSingular(CONJ_PREFIX));

   p1pLabel->setText  (prefix.pers1Plural(CONJ_PREFIX));
   p2pLabel->setText  (prefix.pers2Plural(CONJ_PREFIX));
   p3pfLabel->setText (prefix.pers3FemalePlural(CONJ_PREFIX));
   p3pmLabel->setText (prefix.pers3MalePlural(CONJ_PREFIX));
   p3pnLabel->setText (prefix.pers3NaturalPlural(CONJ_PREFIX));

   p1sLabel->setBuddy(p1sField);
   p2sLabel->setBuddy(p2sField);
   p3snLabel->setBuddy(p3snField);
   p3smLabel->setBuddy(p3smField);
   p3sfLabel->setBuddy(p3sfField);

   p1pLabel->setBuddy(p1pField);
   p2pLabel->setBuddy(p2pField);
   p3pnLabel->setBuddy(p3pnField);
   p3pmLabel->setBuddy(p3pmField);
   p3pfLabel->setBuddy(p3pfField);

   if (mtime >= 1000) { // more than 1000 milli-seconds
     if (qtimer == 0)
       qtimer = new QTimer( this );
     connect( qtimer, SIGNAL(timeout()), this, SLOT(timeoutReached()) );
     qtimer->start(mtime, TRUE);
   }
   all_known = true;
   next();
}


VerbQueryDlg::~VerbQueryDlg()
{
}


bool VerbQueryDlg::next()
{
  resetAllFields();
  QString s, type;
  if (q_ocol == 0)
    s = kv_exp->getOriginal();
  else
    s = kv_exp->getTranslation(q_ocol);

  type = conjugations.getType(current);
  groupTitle->setText ((QString)i18n("Enter ")+conjugations.getName(type)+i18n(" for: ")+s);

  if (current < (int) conjugations.numEntries()-1 )
    current++;

  p1sField->setText("");
  p1sField->setEnabled (!conjugations.pers1Singular(type).isEmpty());

  p2sField->setText("");
  p2sField->setEnabled (!conjugations.pers2Singular(type).isEmpty());

  p3sfField->setText("");
  p3sfField->setEnabled (!conjugations.pers3FemaleSingular(type).isEmpty());

  p3smField->setText("");
  p3smField->setEnabled (!conjugations.pers3MaleSingular(type).isEmpty());

  p3snField->setText("");
  p3snField->setEnabled (!conjugations.pers3NaturalSingular(type).isEmpty());

  p1pField->setText("");
  p1pField->setEnabled (!conjugations.pers1Plural(type).isEmpty());

  p2pField->setText("");
  p2pField->setEnabled (!conjugations.pers2Plural(type).isEmpty());

  p3pfField->setText("");
  p3pfField->setEnabled (!conjugations.pers3FemalePlural(type).isEmpty());

  p3pmField->setText("");
  p3pmField->setEnabled (!conjugations.pers3MalePlural(type).isEmpty());

  p3pnField->setText("");
  p3pnField->setEnabled (!conjugations.pers3NaturalPlural(type).isEmpty());

  return false;
}


void VerbQueryDlg::optionsClicked()
{
   emit sigOptions();
}


void VerbQueryDlg::showAllClicked()
{
  resetAllFields();
  if (current >= (int) conjugations.numEntries()-1 ) {
    dont_know->setDefault(true);
  }
  else
    next();
 
  QString type = conjugations.getType (current);

  p1sField->setText  (conjugations.pers1Singular(type));
  p2sField->setText  (conjugations.pers2Singular(type));
  p3sfField->setText (conjugations.pers3FemaleSingular(type));
  p3smField->setText (conjugations.pers3MaleSingular(type));
  p3snField->setText (conjugations.pers3NaturalSingular(type));

  p1pField->setText  (conjugations.pers1Plural(type));
  p2pField->setText  (conjugations.pers2Plural(type));
  p3pfField->setText (conjugations.pers3FemalePlural(type));
  p3pmField->setText (conjugations.pers3MalePlural(type));
  p3pnField->setText (conjugations.pers3NaturalPlural(type));

}


void VerbQueryDlg::verifyClicked()
{
  QString type = conjugations.getType(current);

  bool all_known = true;

  if (!verifyField (p1sField, conjugations.pers1Singular(type)))
    all_known = false;

  if (!verifyField (p2sField, conjugations.pers2Singular(type)))
    all_known = false;

  if (!verifyField (p3sfField, conjugations.pers3FemaleSingular(type)))
    all_known = false;

  if (!verifyField (p3smField, conjugations.pers3MaleSingular(type)))
    all_known = false;

  if (!verifyField (p3snField, conjugations.pers3NaturalSingular(type)))
    all_known = false;


  if (!verifyField (p1pField, conjugations.pers1Plural(type)))
    all_known = false;

  if (!verifyField (p2pField, conjugations.pers2Plural(type)))
    all_known = false;

  if (!verifyField (p3pfField, conjugations.pers3FemalePlural(type)))
    all_known = false;

  if (!verifyField (p3pmField, conjugations.pers3MalePlural(type)))
    all_known = false;

  if (!verifyField (p3pnField, conjugations.pers3NaturalPlural(type)))
    all_known = false;

  if (all_known)
    know_it->setDefault(true);
  else
    dont_know->setDefault(true);
}


void VerbQueryDlg::resetAllFields()
{
  resetField(p1sField);
  resetField(p2sField);
  resetField(p3sfField);
  resetField(p3smField);
  resetField(p3snField);

  resetField(p1pField);
  resetField(p2pField);
  resetField(p3pfField);
  resetField(p3pmField);
  resetField(p3pnField);
}


void VerbQueryDlg::knowItClicked()
{
   resetAllFields();
   if (current >= (int) conjugations.numEntries()-1 ) {
     if (all_known)
       done (Known);
     else
       done (Unknown);
   }
   else
     next();
}


void VerbQueryDlg::timeoutReached()
{
   if (++current >= (int) conjugations.numEntries() )
     done (Timeout);
   else
     next();

   qtimer->start(query_time, TRUE);
}


void VerbQueryDlg::dontKnowClicked()
{
   all_known = false;
   if (current >= (int) conjugations.numEntries()-1 )
     done (Unknown);
   else
     next();
}


void VerbQueryDlg::stopItClicked()
{
   done (StopIt);
}


void VerbQueryDlg::editClicked()
{

   if (qtimer != 0)
     qtimer->stop();

   emit sigEditEntry (q_row, KV_COL_ORG+q_ocol);
}


void VerbQueryDlg::keyPressEvent( QKeyEvent *e )
{
  switch( e->key() )
  {
    case Key_Escape:
      dontKnowClicked();
    break;
      
    case Key_Return:
    case Key_Enter:
      if (dont_know->isDefault() )
        dontKnowClicked();
      else if (know_it->isDefault() )
        knowItClicked();
      else if (show_all->isDefault() )
        showAllClicked();
    break;
      
    default:
      e->ignore();
    break;
  }
}


void VerbQueryDlg::slotP3pfChanged(EA_QTSTR)
{
  resetField(p3pfField);
}


void VerbQueryDlg::slotP3snChanged(EA_QTSTR)
{
  resetField(p3snField);
}


void VerbQueryDlg::slotReturnPressed()
{
}


void VerbQueryDlg::slotP3smChanged(EA_QTSTR)
{
  resetField(p3smField);
}


void VerbQueryDlg::slotP3pnChanged(EA_QTSTR)
{
  resetField(p3pnField);
}


void VerbQueryDlg::slotP3sfChanged(EA_QTSTR)
{
  resetField(p3sfField);
}


void VerbQueryDlg::slotP1sChanged(EA_QTSTR)
{
  resetField(p1sField);
}


void VerbQueryDlg::slotP2sChanged(EA_QTSTR)
{
  resetField(p2sField);
}


void VerbQueryDlg::slotP3pmChanged(EA_QTSTR)
{
  resetField(p3pmField);
}


void VerbQueryDlg::slotP1pChanged(EA_QTSTR)
{
  resetField(p1pField);
}


void VerbQueryDlg::slotP2pChanged(EA_QTSTR)
{
  resetField(p2pField);
}

