/***************************************************************************
               GroupOptPage.h  -  query groups dialog page
                        -------------------
    begin                : Mon Nov 1 13:10:21 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef GroupOptPage_included
#define GroupOptPage_included

#include "GroupOptPageData.h"

#include <vector.h>

struct PreSetting {
 PreSetting (QString n, QString q, QString t, QString b)
    : name(n),
      query_set(q),
      thresh_set(t),
      block_set(b) {}

   QString name,
           query_set,
           thresh_set,
           block_set;
};


class GroupOptPage : public GroupOptPageData
{
    Q_OBJECT

public:

    GroupOptPage
    (
        vector<PreSetting>   preset,
        QWidget            *parent = NULL,
        const char         *name = NULL
    );

    virtual ~GroupOptPage();

public slots:
    virtual void initFocus() const;

protected:
    void keyPressEvent( QKeyEvent * );
    virtual void slotGroupSelected(int item);
    virtual void slotDeleteGroup();
    virtual void slotNewGroup();
    virtual void slotStoreGroup();
    virtual void slotRecallGroup();

    void updateButtons();

signals:
    void selectGroup(int);
    void deleteGroup(int);
    void modifyGroup(int);
    void newGroup (const QString&);

};
#endif // GroupOptPage_included
