/* -*- C++ -*- */

#ifndef _GAMEVIEWWIDGET_H_
#define _GAMEVIEWWIDGET_H_

#include <qwidget.h>
#include <qtimer.h>

#include "PerformGamePlay.h"

class GameViewWidget : public QWidget
{
	Q_OBJECT

public:
	GameViewWidget (QWidget *parent, const char *name=0);
	~GameViewWidget();

	void setPerformGamePlay (PerformGamePlay *_performGamePlay);

	enum ActionKeysEnumerate {KEY_MOVE_LEFT,KEY_MOVE_RIGHT,
				  KEY_MOVE_UP,KEY_MOVE_DOWN,
				  KEY_MOVE_TO_BOTTOM,KEY_MOVE_FAST_TO_BOTTOM,
				  KEY_ROTATE_POS_X,KEY_ROTATE_NEG_X,
				  KEY_ROTATE_POS_Y,KEY_ROTATE_NEG_Y,
				  KEY_ROTATE_POS_Z,KEY_ROTATE_NEG_Z,
				  KEY_PAUSE,
				  KEY_NOT_USED};
	static int ActionKeys [KEY_NOT_USED];

	/** In higher levels less time for thinking of movement. */
	void setTimeLevel (int _level) { baseTimeLevel=_level; };


 public slots:
	void newGame();

	/** Moves figure to z=0. emits gameEnded if so. Returns true if hit bottom or collision. */
	bool lowerFigure();

	void increaseTimeLevel();

	void fastLoweringFigure();

signals:
 	void updatePoints (int i);
	void gameEnded();
	void newLevel (int i);

protected:

	bool needsRecalc;
	QTimer *loweringTimer;		// shoots when the time for one move is out
	QTimer *levelIncreaseTimer;	// shoots when level should be increased
	QTimer *fastLoweringTimer;
	
	PerformGamePlay *performGamePlay;

	int baseTimeLevel;		// time level which is set on every new game
	
	void keyPressEvent (QKeyEvent *e);
	void paintEvent (QPaintEvent *e);
	void resizeEvent (QResizeEvent *e);
	
	void recalcDisplay();

	void gameEnds();
};

#endif _GAMEVIEWWIDGET_H_
