/***************************************************************************
                          map.h  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAP_H
#define MAP_H

#include "field.h"
#include "token.h"
#include "globals.h"

#include <stdlib.h>
#include <fstream.h>
#include <iostream.h>
#include <string.h>
#include <ctype.h>

/** The map to play on.
  * Maps contain several fields. The definition of a map can be loaded from an ASCII-file.
  * See file map.readme for more details.
  * @author Ralf-Christian Juergensen
  */
class Map
{
public:
    /** Construnct an empty, not valid, map. */
    Map(void);
    /** Constructs a new map and load a map-file */
    Map(const char* mapFileName);
    /** Constructs a new map with all fields empty (Player: NONE, Value: EMPTY) */
    Map(int width, int height);
    /** Copy an entire map from another map*/
    Map(const Map& map);
    /** Destroy the map */
    ~Map(void);

    // General methods
    
    /** Load a new map */
    void load(const char* mapFileName);
    
    Field getField(int x, int y);
    Value getFieldValue(int x, int y);
    Player getFieldPlayer(int x, int y);
    		
    int getWidth(void);
    int getHeight(void);
    
    // Edit methods
    
//    void save(const char* mapFileName);

    void setField(int x, int y, Field field);
    void setFieldValue(int x, int y, Value value);
    void setFieldPlayer(int x, int y, Player player);

//    void setWidth(int width);
//    void setHeight(int height);
    
//    void delRow(int row);
//    void delCol(int col);
//    void insRow(int row);
//    void insCol(int col);
    
//    void clear(void);
    
    // Gameplay methods
        		
    /** Returns number of fields with matching player and value */
    int checkFields(Player player, Value value);		
        
    void and(int x, int y, bool bit);		
    void or(int x, int y, bool bit);		
    void xor(int x, int y, bool bit);
    		
private:
    int width;      // width in fields
    int height;     // height in fields
    Field* fields;  // array of fields

    void deleteFields(void);
    		
    /** Calculates linear position in field-array */
    int coords(int x, int y) {return x + y * width;}
    
    bool inBounds(int x, int y) {return x >= 0 && x < width && y >= 0 && y < height;}
    void checkBounds(int x, int y) {if(!inBounds(x, y)) throw "Map-access: Out of Bounds!";}
    
    /** The tokens in a map-file.
      * DO NOT change the position of this id's in the enum-list!!!!!!
      */
    enum TokenID
    {
        WIDTH=0,
        HEIGHT,
        NO_PLAYER,
        PLAYER_ONE,
        PLAYER_TWO,
        OFF_FIELD,
        ON_FIELD,
        EMPTY_FIELD,
        PENGUIN_FIELD,
        LAST_TOKEN      // This is not a valid token and MUST be the last in this list!
    };
    
    void parseDefines(ifstream& mapFile, Token* tokenList);
    void parseMapLines(ifstream& mapFile, Token* tokenList);
    
    /** Read an integer-value from string with following syntax:
      * "TOKEN=INT;"
      */
    int* readInt(const char* string, const char* token);
    /** Read a char from string with following syntax:
      * "TOKEN=CHAR;"
      */
    char* readChar(const char* string, const char* token);
};

#endif // MAP_H