/***************************************************************************
                          playground.h  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYGROUND_H
#define PLAYGROUND_H

#include "cursor.h"
#include "field.h"
#include "map.h"
#include "globals.h"

#include <stdlib.h>
#include <iostream.h>

/** The core-logic for the game.
  * Contains 'only' system-independent code.
  * @author Ralf-Christian Juergensen
  */
class PlayGround
{
public:
            
    PlayGround(Player, const char* mapFileName);
    
    void newGame(Player, const char* mapFileName);
    		
    int getWidth(void);
    int getHeight(void);
    		
    int getCursorX(void);
    int getCursorY(void);
    		
    Type getCursorType(void);
    bool getCursorBit(int no);
    
    Field getField(int x, int y);
    		
    Player getPlayer(void);
    
    // returns number of OFF-fields for player
    int getScore(Player);
    		
protected:
            
    void initRound(void);
    	
    // returns the winner. BUT if both set all of their fields to ON, the CURRENT player wins.
    Player checkWinner(void);
    		
    // swap between player one and two
    void changePlayer(void);
    
    void setCursor(void);
    void cursorUp(void);
    void cursorDown(void);
    void cursorLeft(void);
    void cursorRight(void);
    
private:
                    
    Cursor cursor;  // playing cursor.
    Map map;        // the map with all fields containing
    Player player;  // the current player
};

#endif // PLAYGROUND_H
