/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qtabbar.h>
#include <kapp.h> 
#include <klocale.h>
#include <kcontainer.h> 

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "optionsDialog.h"
#include "DebugInfo.h"


/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/


//
//      Name: KalaxConfigDialog( QWidget *parent ) 
//
//   Comment: read the configuration
//            build up the dialog
//            do not show the dialog
// Parameter:
//
//
KalaxConfigDialog::KalaxConfigDialog( QWidget *parent )
              :KWizard( parent, "KalaxConfigDialog", TRUE )  
{

  dprintf( "START::(>%p<)\n", parent );

  this->readConfig();

  this->setOkButton();
  this->setCancelButton();
  this->setHelpButton();
  this->connect( this,  SIGNAL( okclicked()),     SLOT(okBtnClicked()) ); 
  this->connect( this,  SIGNAL( cancelclicked()), SLOT(cancelBtnClicked()) );
  this->connect( this,  SIGNAL( helpclicked(int)),   SLOT(helpBtnClicked( int )) );

  KContainerLayout *kclp=new KContainerLayout( 0L,"", KContainerLayout::Vertical ); // tab, (const char*)"kclpSpeed" );
  kclp->setStartOffset( 5 );
  kclp->setEndOffset( 5 );
     QLabel *lti = new QLabel("timer ticks for main game loop [ms]", kclp );
    timerIntervalSl=new KSlider ( 20, 500, 20, timerInterval, QSlider::Horizontal, kclp );
    kclp->packStart( lti,  FALSE, FALSE, 5 );
    kclp->packStart( timerIntervalSl );

    QLabel *leets = new QLabel("move enemies every # timer tick", kclp );
    moveEnemyEveryTickSl=new KSlider ( 1, 5, 1, moveEnemyEveryTick, QSlider::Horizontal, kclp );
    kclp->packStart( leets, FALSE, FALSE, 5 );
    kclp->packStart( moveEnemyEveryTickSl );

    QLabel *lsse = new QLabel("move enemies pixel step", kclp );
    spriteStepEnemySl=new KSlider ( 1, 10, 1, spriteStepEnemy, QSlider::Horizontal, kclp );
    kclp->packStart( lsse, FALSE, FALSE, 5 );
    kclp->packStart( spriteStepEnemySl );

    QLabel *lsses = new QLabel("move enemy shots pixel step", kclp );
    spriteStepEnemyShotSl=new KSlider ( 1, 10, 1, spriteStepEnemyShot, QSlider::Horizontal, kclp );
    kclp->packStart( lsses, FALSE, FALSE, 5 );
    kclp->packStart( spriteStepEnemyShotSl );
 
    QLabel *lssps = new QLabel("move player shots pixel step", kclp );
    spriteStepPlayerShotSl=new KSlider ( 1, 10, 1, spriteStepPlayerShot, QSlider::Horizontal, kclp );
    kclp->packStart( lssps, FALSE, FALSE, 5 );
    kclp->packStart( spriteStepPlayerShotSl );

    KWizardPage *p = new KWizardPage;
    p->w = kclp;
    p->enabled = true;
    p->title = "Speed values";
  this->addPage( p );


  KContainerLayout *kclp2=new KContainerLayout(  0L,"", KContainerLayout::Vertical ); //(QWidget*)tab2, (const char*)"kclpSpeed" );
  kclp2->setStartOffset( 5 );
  kclp2->setEndOffset( 5 );
    QLabel *l2 = new QLabel("path to game flightplans", kclp2 );
    flightPlanPathPs=new KPathSelector( kclp2, 0L, flightPlanPath );
    kclp2->packStart( l2 );
    kclp2->packStart( flightPlanPathPs );

    QLabel *llp = new QLabel("path to game levels", kclp2 );
    levelPathPs= new KPathSelector( kclp2, 0L, levelPath );
    kclp2->packStart( llp, FALSE, FALSE, 5 );
    kclp2->packStart( levelPathPs );

    QLabel *lsp = new QLabel("path to game sprites", kclp2 );
    spritesPathPs=new KPathSelector( kclp2, 0L, spritesPath );
    kclp2->packStart( lsp, FALSE, FALSE, 5 );
    kclp2->packStart( spritesPathPs );

    QLabel *lspa = new QLabel("path to game sounds", kclp2 );
    soundPathPs=new KPathSelector( kclp2, 0L, soundPath );
    kclp2->packStart( lspa, FALSE, FALSE, 5 );
    kclp2->packStart( soundPathPs  );
   
    KWizardPage *p2 = new KWizardPage;
    p2->w = kclp2;
    p2->enabled = true;
    p2->title = "Data pathes";
  this->addPage( p2 ); 


  KContainerLayout *kclp3=new KContainerLayout( 0L,"", KContainerLayout::Vertical );
  kclp3->setStartOffset( 5 );
  kclp3->setEndOffset( 5 );

    QLabel *lps = new QLabel("nr. of player ships", kclp3 );
    playerShipCountSl=new KSlider ( 1, 10, 1, playerShipCount, QSlider::Horizontal, kclp3 );
    kclp3->packStart( lps,  FALSE, FALSE, 5 );
    kclp3->packStart( playerShipCountSl );

    QLabel *lmps = new QLabel("max player shots at time", kclp3 );
    maxPlayerShotsSl=new KSlider ( 1, 5, 1, maxPlayerShots, QSlider::Horizontal, kclp3 );
    kclp3->packStart( lmps, FALSE, FALSE, 5 );
    kclp3->packStart( maxPlayerShotsSl );

    QLabel *lmes = new QLabel("max enemy shots at time", kclp3 );
    maxEnemyShotsSl=new KSlider ( 1, 10, 1, maxEnemyShots, QSlider::Horizontal, kclp3 );
    kclp3->packStart( lmes, FALSE, FALSE, 5 );
    kclp3->packStart( maxEnemyShotsSl );

    QLabel *lme = new QLabel("max enemies in level", kclp3 );
    maxEnemysSl=new KSlider ( 1, 40, 1,maxEnemys , QSlider::Horizontal, kclp3 );
    kclp3->packStart( lme, FALSE, FALSE, 5 );
    kclp3->packStart( maxEnemysSl );
 
    QLabel *lmed = new QLabel("????", kclp3 );
    maxEnemyDestrSl=new KSlider ( 1, 10, 1, maxEnemyDestr, QSlider::Horizontal, kclp3 );
    kclp3->packStart( lmed, FALSE, FALSE, 5 );
    kclp3->packStart( maxEnemyDestrSl );

    //kclp3->sizeToFit();
    KWizardPage *p3 = new KWizardPage;
    p3->w = kclp3;
    p3->enabled = true;
    p3->title = "Cheats";
  this->addPage( p3 );

  this->setCaption( klocale->translate("Options"));
  this->setMinimumSize( 400, 400 );
  this->reject();  // do not show the dialog, only on signal show()
  dprintf( "END::()\n");

}

//
//      Name: KalaxConfigDialog::~KalaxConfigDialog() 
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
KalaxConfigDialog::~KalaxConfigDialog()
{
  dprintf( "START::()\n");
  // delete all widgets
  dprintf( "END::()\n");
}


//
//      Name: KalaxConfigDialog::show() 
//
//   Comment: show the dialog
//            fill in the actual configuration values
//
//
void KalaxConfigDialog::show()
{
  dprintf( "START::()\n");
  this->readConfig();

  timerIntervalSl->setValue( timerInterval );
  moveEnemyEveryTickSl->setValue( moveEnemyEveryTick );
  spriteStepEnemySl->setValue( spriteStepEnemy );
  spriteStepEnemyShotSl->setValue( spriteStepEnemyShot );
  spriteStepPlayerShotSl->setValue( spriteStepPlayerShot );

  flightPlanPathPs->setPath( flightPlanPath );
  levelPathPs->setPath( levelPath );
  spritesPathPs->setPath( spritesPath );
  soundPathPs->setPath( soundPath );

  playerShipCountSl->setValue( playerShipCount );
  maxPlayerShotsSl->setValue( maxPlayerShots );
  maxEnemyShotsSl->setValue( maxEnemyShots );
  maxEnemysSl->setValue( maxEnemys );
  maxEnemyDestrSl->setValue( maxEnemyDestr );
  
  KWizard::show();
  dprintf( "END::()\n");
}

//
//      Name: KalaxConfigDialog::okBtnClicked() 
//
//   Comment: terminate the dialog and set done to 1
//            get the configuration values to local vars.
//
void KalaxConfigDialog::okBtnClicked()
{
  dprintf( "START::()\n");
  getValues();
  done(1);
  dprintf( "END::()\n");
}
//
//      Name: KalaxConfigDialog::cancelBtnClicked() 
//
//   Comment: terminate the dialog and set done to 0
//
void KalaxConfigDialog::cancelBtnClicked()
{
  dprintf( "START::()\n");
  done(0);
  dprintf( "END::()\n");
}

//
//      Name: KalaxConfigDialog::helpBtnClicked()  
//
//   Comment: show help for the dialog
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void KalaxConfigDialog::helpBtnClicked( int actPage )
{
  dprintf( "START::()\n");
  QString filename( APPNAME );
  switch ( actPage )
  {
    case 1: 
            filename+=HELP_PATH;
    break;

    case 2: 
            filename+=HELP_CHEAT;
    break;

    case 0:
    default:
            filename+=HELP_SPEED;
    break;

  } //switch ( actPage )

  kapp->invokeHTMLHelp( filename, "" );
  dprintf( "END::()\n");
}


//
//      Name: KalaxConfigDialog::writeConfig() 
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void KalaxConfigDialog::writeConfig()
{
  dprintf( "START::()\n");
  KConfig *config = kapp->getKApplication()->getConfig();
  config->setGroup( APPNAME );

  getValues();

  config->writeEntry( "RefreshRate",timerInterval ); 
  config->writeEntry( "MoveEnemyEveryTick", moveEnemyEveryTick );
  config->writeEntry( "EnemySpriteStep",spriteStepEnemy  );
  config->writeEntry( "EnemyShotSpriteStep", spriteStepEnemyShot );
  config->writeEntry( "PlayerShotStep", spriteStepPlayerShot );

  config->writeEntry( "FlightPlanPath", flightPlanPath );
  config->writeEntry( "SpritesPath", spritesPath );
  config->writeEntry( "LevelPath",  levelPath );
  config->writeEntry( "SoundPath",  soundPath );

  config->writeEntry( "PlayerShipCount", playerShipCount );
  config->writeEntry( "MaxPlayerShots",maxPlayerShots  );
  config->writeEntry( "MaxEnemyShots", maxEnemyShots );
  config->writeEntry( "MaxEnemyCount", maxEnemys );
  config->writeEntry( "MaxEnemyDestr", maxEnemyDestr );

  config->sync();
  dprintf( "END::()\n");

}

//
//      Name:KalaxConfigDialog::readConfig()  
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void KalaxConfigDialog::readConfig()
{
  KConfig *config = kapp->getKApplication()->getConfig();
  
  dprintf( "START::()\n");

  config->setGroup( APPNAME );

  flightPlanPath = kapp->kde_datadir() + "/kalax/flightplans";
  spritesPath = kapp->kde_datadir() + "/kalax/sprites";
  levelPath  = kapp->kde_datadir() + "/kalax/level";
  soundPath = kapp->kde_datadir() + "/kalax/sounds";


  timerInterval       =config->readNumEntry( "RefreshRate", 60 ); 
  moveEnemyEveryTick  =config->readNumEntry( "MoveEnemyEveryTick", 2 );
  spriteStepEnemy     =config->readNumEntry( "EnemySpriteStep", 3  );
  spriteStepEnemyShot =config->readNumEntry( "EnemyShotSpriteStep", 5 );
  spriteStepPlayerShot=config->readNumEntry( "PlayerShotStep", 7 );

  flightPlanPath=config->readEntry( "FlightPlanPath", flightPlanPath );
  spritesPath=config->readEntry( "SpritesPath", spritesPath );
  levelPath=config->readEntry( "LevelPath",  levelPath );
  soundPath=config->readEntry( "SoundPath",  soundPath );

  playerShipCount=config->readNumEntry( "PlayerShipCount", 5 );
  maxPlayerShots =config->readNumEntry( "MaxPlayerShots", 5  );
  maxEnemyShots  =config->readNumEntry( "MaxEnemyShots", 20 );
  maxEnemys      =config->readNumEntry( "MaxEnemyCount", 50 );
  maxEnemyDestr  =config->readNumEntry( "MaxEnemyDestr", 5 );

  dprintf( "END::()\n");
}


// get values from gui to class-vars
void KalaxConfigDialog::getValues()
{
  timerInterval = timerIntervalSl->value();
  moveEnemyEveryTick = moveEnemyEveryTickSl->value();
  spriteStepEnemy = spriteStepEnemySl->value();
  spriteStepEnemyShot = spriteStepEnemyShotSl->value();
  spriteStepPlayerShot = spriteStepPlayerShotSl->value();

  flightPlanPath = flightPlanPathPs->selectedPath;
  levelPath = levelPathPs->selectedPath;
  spritesPath = spritesPathPs->selectedPath;
  soundPath = soundPathPs->selectedPath;

  playerShipCount = playerShipCountSl->value();
  maxPlayerShots = maxPlayerShotsSl->value();
  maxEnemyShots = maxEnemyShotsSl->value();
  maxEnemys = maxEnemysSl->value();
  maxEnemyDestr = maxEnemyDestrSl->value();
}











