/***************************************************************************
                          cconnectserver.cpp  -  description
                             -------------------
    begin                : Sun Dec 12 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>

#include "cconnectserver.h"


CConnectServer::CConnectServer(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	initConnections();
	
	KConfig *conf = kapp->getConfig();
	txtFleetName->setText(conf->readEntry("fleetname"," "));
	txtServer->setText(conf->readEntry("server"," "));
}

CConnectServer::~CConnectServer(){
}

/** returns the name choosen for the fleet */
QString CConnectServer::getFleetName() const
{
	return txtFleetName->text();
}

/** returns the name of the server for the connection */
QString CConnectServer::getServerName() const
{
	return txtServer->text();
}

/** this one will be called when the user presses OK */
void CConnectServer::slotOkClicked()
{
	KConfig *conf = kapp->getConfig();
	conf->writeEntry("fleetname",txtFleetName->text());
	conf->writeEntry("server",txtServer->text());
	done(IDOK);
}

/**  */
void CConnectServer::slotCancelClicked()
{
	done(IDCANCEL);
}

/** sets up the connections between constituent widgets */
void CConnectServer::initConnections()
{
  connect (cmdOk, SIGNAL (clicked ()), SLOT (slotOkClicked ()));
  connect (cmdCancel, SIGNAL (clicked ()), SLOT (slotCancelClicked ()));
}
