/***************************************************************************
                          kbattlefield.h  -  description
                             -------------------
    begin                : Sat Sep 11 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@geocities.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KBATTLEFIELD_H
#define KBATTLEFIELD_H

#include <qwidget.h>
#include "kbattleshipviewbase.h"

/**the Battle field
  *@author Alessandro Praduroux
  */

class KBattleField:public KBattleshipViewBase
{
  Q_OBJECT
public:
  KBattleField (QWidget * parent = 0, const char *name = 0);
   ~KBattleField ();
/** ritorna lo stato del campo di battaglia */
  bool isActive ();

protected:			// Protected methods
	/**  */
  virtual void paintEvent (QPaintEvent *);

  virtual void mouseMoveEvent (QMouseEvent *);
	
	/**  */	
  virtual void paintShips (QPainter * p);
	
	/**  */
  void paintField (QPainter * p);
	
	/**  */
  virtual void mouseReleaseEvent (QMouseEvent *);
	
	/**  */
  virtual void cellClicked (int x, int y, int button);

  /**  */
	virtual void updateView();

public slots:		// Public slots
	/** disattiva il campo di battaglia */
  void deactivate ();

	/** rende attiva il campo di battaglia */
  void activate ();

private:			// Private attributes
	/**  */
  bool active;
};

#endif

