/***************************************************************************
                          kbattleshipclient.cpp  -  description
                             -------------------
    begin                : Sun Dec 12 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//standard include files
#include <iostream.h>

// include files for Qt

// include files for KDE
#include <ksock.h>
#include <kapp.h>

// application specific includes
#include "kbattleshipclient.h"
#include "kmessage.h"
#include "resource.h"


KBattleshipClient::KBattleshipClient(QString server)
{
	cliSock = new KSocket((const char *)server,ID_PORT);	
	// TODO: inserting control of good connection
	
	connect(cliSock,SIGNAL(readEvent(KSocket *)),this,SLOT(slotReadEvent(KSocket *)));
	connect(cliSock,SIGNAL(closeEvent(KSocket *)),this,SLOT(slotCloseEvent(KSocket *)));
	cliSock->enableRead(true);
	
}

KBattleshipClient::~KBattleshipClient()
{
	
	if (cliSock)
		delete cliSock;
}


/** sets the name of the fleet */
void
KBattleshipClient::setName(QString name)
{
	KMessage msg;
	
	_name = name;
	msg.setType(IDM_NAME);
	msg.addField("name",_name);
	area = MY_AREA;
	sendMessage(msg);
}

/**  */
QString KBattleshipClient::fleetName()
{
	return _name;
}

/**  */
QString KBattleshipClient::enemyName()
{
	return _enemy;
}

/**  */
void KBattleshipClient::processMsg(KMessage &msg)
{
	bool changed = false;
	switch (msg.getType())
		{
			case IDM_NAME:
				_enemy = msg.getField("name");
				_status = PLACE;
				area = ALL_AREA;
				changed = true;
				break;
			
			default:
				break;
		}				
	
	if (changed)
		emit dataChanged();
		
	KBattleshipDocBase::processMsg(msg);

}
/**  */
void KBattleshipClient::endShips()
{
	if (ready && enemyReady)
		{
			_status = WAIT;
			getApplication()->slotStatusMsg(i18n("Waiting for enemy"));
		}
}
