/***************************************************************************
                          kbattleshipview.cpp  -  description
                             -------------------
    begin                : dom dic 12 21:31:30 CET 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qlineedit.h>

// application specific includes
#include "kbattleshipview.h"
#include "kbattleshipdoc.h"
#include "kbattleshipdocbase.h"
#include "kbattleship.h"
#include "kmybattlefield.h"
#include "kyourbattlefield.h"
#include "resource.h"

KBattleshipView::KBattleshipView(QWidget *parent, const char *name)
	: KBattleshipViewBase(parent, name)
{	
  myField = new KMyBattleField (this);
  myField->setGeometry(0,0,320,320);
  getDocument()->addView(myField);
	
  yourField = new KYourBattleField (this);
  yourField->setGeometry(320,0,320,320);
  getDocument()->addView(yourField);
  	
	messageList = new QListBox(this);
  messageList->setGeometry(0,320,640,100);
  		
	messageLine = new QLineEdit(this);
	messageLine->setGeometry(0,420,640,20);
	connect(messageLine,SIGNAL(returnPressed()),this,SLOT(slotChatMessage()));
	
	setFixedSize(640,440);
	
  setBackgroundMode(PaletteBase);
}

KBattleshipView::~KBattleshipView()
{
}

KBattleshipDoc *KBattleshipView::getDocument() const
{
  KBattleshipApp *theApp=(KBattleshipApp *) parentWidget();

  return theApp->getDocument();
}

void KBattleshipView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

  printpainter.end();
}

/**  */
KBattleshipDocBase * KBattleshipView::getDocBase()
{
	return getDocument()->getDocBase();
}

/**  */
void KBattleshipView::slotChatMessage()
{
	if (!getDocBase())
		return;
	
	getDocBase()->chat(messageLine->text());
	messageLine->clear();
	getDocument()->slotDataChanged();
}

/**  */
void KBattleshipView::paintEvent(QPaintEvent *e)
{	
}
/**  */
void KBattleshipView::updateView()
{
	if (getDocBase()->updatedArea() != CHAT_AREA)
		return;

	// only update the list of messages
	messageList->clear();
	messageList->insertStrList(getDocBase()->getChatMsg());
	messageList->setBottomItem(messageList->count());

}
