/***************************************************************************
                          kmessage.h  -  description                              
                             -------------------                                         
    begin                : Tue Jul 27 1999                                           
    copyright            : (C) 1999 by pradu                         
    email                : pradu@geocities.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMESSAGE_H
#define KMESSAGE_H

#include <iostream.h>
#include <strstream.h>
#include <qobject.h>
#include <qdict.h>
#include <qstring.h>

/**
 * message, it builds and interprets messages
 * @author pradu
 */

class KMessage : public QObject
{
	Q_OBJECT


	friend ostream& operator <<(ostream&, KMessage *);
	friend istream& operator >>(istream&, KMessage *);

public:

	KMessage();
	~KMessage();

  /** returns the type of the message */
  int getType();

  /** returns a field, null if the field does not exists */
  virtual const QString & getField(const char * name) const;

  /**
	* builds a message based upon a
	* string
	*/
  KMessage(const char * buf);

  /** adds a field to the message */
  void addField(const char * name, const char * content);

  /** sets the type of  message */
  void setType(int _type);

  /**  */
  void addField(const char * name, int content);

  /**  */
  void addField(const char * name, const QString & content);

protected: // Protected methods
  /**  */
  virtual void parseBuf(const char * buf);

private: // Private attributes
  /** the type of message */
  int type;
	
	QDict<QString> fields;


public slots: // Public slots
  /**  */
  void clear();
};

ostream& operator <<(ostream&, KMessage *);
istream& operator >>(istream&, KMessage *);

#endif
















