#include "kblackjack.h" 
#include "table_option.h" 
#include <qpushbt.h>
#include <qradiobt.h> 


TableOption::
TableOption(int num_decks, int num_splits, int shuffle_point,
            QWidget* parent) : QDialog(parent, "", TRUE), 
            _num_decks_buttons(0), _num_split_buttons(0), 
            _num_shuffle_buttons(0) {
   int i;
   _deck_bg = new QButtonGroup(this, "NumDecksGroup");
   _deck_bg->setTitle("Decks");
   _split_bg = new QButtonGroup(this, "NumSplitsGroup");
   _split_bg->setTitle("Maximum Splits");
   _shuffle_bg = new QButtonGroup(this, "ShuffleGroup");
   _shuffle_bg->setTitle("Shuffle Point");

   _pad = 10;
   _btn_height = 26;
   _btn_width  = 90;

   _deck_list.setAutoDelete(TRUE);
   _deck_list.append(new int(1));
   _deck_list.append(new int(2));
   _deck_list.append(new int(4));
   _deck_list.append(new int(6));

   _split_list.setAutoDelete(TRUE);
   for (i = 1; i <= MAX_SPLITS; i++)
      _split_list.append(new int(i));

   _shuffle_list.setAutoDelete(TRUE);
   _shuffle_list.append(new int(20));
   _shuffle_list.append(new int(30));
   _shuffle_list.append(new int(40));
   _shuffle_list.append(new int(50));

   for (i = 0; i < _deck_list.count(); i++)
      addDeckButton(*(_deck_list.at(i)));

   for (i = 0; i < _split_list.count(); i++)
      addSplitButton(*(_split_list.at(i)));

   for (i = 0; i < _shuffle_list.count(); i++)
      addShuffleButton(*(_shuffle_list.at(i)));

   setDecks(num_decks);
   setSplits(num_splits);
   setShufflePoint(shuffle_point);

   _deck_bg->setGeometry(_pad, _pad, 
              _btn_width + 2 * _pad, (_num_decks_buttons + 1) * _btn_height);
   _split_bg->setGeometry(_deck_bg->width() + 2 * _pad, _pad, 
              _btn_width + 2 * _pad, (_num_split_buttons + 1) * _btn_height);
   _shuffle_bg->setGeometry(_deck_bg->width() + _split_bg->width() + 3 * _pad, 
                            _pad, 
                            _btn_width + 2 * _pad, 
                            (_num_shuffle_buttons + 1) * _btn_height);

   int width = _deck_bg->width() + _split_bg->width() + _shuffle_bg->width() + 
               4 * _pad;
   int x1, x2, y;
 
   x1 = width / 3 - _btn_width / 2;
   x2 = width * 2 / 3 - _btn_width / 2;

   y = _deck_bg->height();
   y = _split_bg->height() > y ? _split_bg->height() : y;
   y = _shuffle_bg->height() > y ? _shuffle_bg->height() : y;
   y += _pad * 2;

   QPushButton *ok, *cancel;
   ok = new QPushButton("OK", this);
   ok->setGeometry(x1, y, _btn_width, _btn_height);
   connect(ok, SIGNAL(clicked()), SLOT(accept()));
   cancel = new QPushButton("Cancel", this);
   cancel->setGeometry(x2, y, _btn_width, _btn_height);
   connect(cancel, SIGNAL(clicked()), SLOT(reject()));

   setFixedSize(width, y + _btn_height + _pad);
}


void TableOption::
addDeckButton(int num) { 
   int half_height = _btn_height / 2;
   QRadioButton *rb;

   QString deck_str;
   deck_str.sprintf("%d", num);
   _num_decks_buttons++; 

   rb = new QRadioButton(deck_str, _deck_bg);
   rb->setGeometry(_pad, _num_decks_buttons * _btn_height - half_height, 
                   _btn_width, _btn_height);
}


void TableOption::
addSplitButton(int num) { 
   int half_height = _btn_height / 2;
   QRadioButton *rb;

   QString split_str;
   split_str.sprintf("%d", num);
   _num_split_buttons++; 

   rb = new QRadioButton(split_str, _split_bg);
   rb->setGeometry(_pad, _num_split_buttons * _btn_height - half_height, 
                   _btn_width, _btn_height);
}


void TableOption::
addShuffleButton(int num) { 
   int half_height = _btn_height / 2;
   QRadioButton *rb;

   QString shuffle_str;
   shuffle_str.sprintf("%d", num);
   _num_shuffle_buttons++; 

   rb = new QRadioButton(shuffle_str, _shuffle_bg);
   rb->setGeometry(_pad, _num_shuffle_buttons * _btn_height - half_height, 
                   _btn_width, _btn_height);
}


void TableOption::
setDecks(int num) {
   int i, best;
   QRadioButton *rb = (QRadioButton *)_deck_bg->find(0);
   QListIterator<int> it(_deck_list);

   for (i = 0, best = 0; it.current(); ++it, i++) {
      if (*it.current() <= num)
         best = i;
      else
         break;
   }

   rb = (QRadioButton *)_deck_bg->find(best);
   rb->setChecked(TRUE);
}


int TableOption::
decks(void) {
   int i, result = 0;
   QRadioButton *rb;

   for (i = 0; rb = (QRadioButton *)_deck_bg->find(i); i++) {
      if (rb->isChecked()) {
         result = *_deck_list.at(i);
         break;
      }
   }
   return(result);
}


void TableOption::
setSplits(int num) {
   int i, best;
   QRadioButton *rb = (QRadioButton *)_split_bg->find(0);
   QListIterator<int> it(_split_list);

   for (i = 0, best = 0; it.current(); ++it, i++) {
      if (*it.current() <= num)
         best = i;
      else
         break;
   }

   rb = (QRadioButton *)_split_bg->find(best);
   rb->setChecked(TRUE);
}


int TableOption::
splits(void) {
   int i, result = 0;
   QRadioButton *rb;

   for (i = 0; rb = (QRadioButton *)_split_bg->find(i); i++) {
      if (rb->isChecked()) {
         result = *_split_list.at(i);
         break;
      }
   }
   return(result);
}


void TableOption::
setShufflePoint(int num) {
   int i, best;
   QRadioButton *rb = (QRadioButton *)_shuffle_bg->find(0);
   QListIterator<int> it(_shuffle_list);

   for (i = 0, best = 0; it.current(); ++it, i++) {
      if (*it.current() <= num)
         best = i;
      else
         break;
   }

   rb = (QRadioButton *)_shuffle_bg->find(best);
   rb->setChecked(TRUE);
}


int TableOption::
shufflePoint(void) {
   int i, result = 0;
   QRadioButton *rb;

   for (i = 0; rb = (QRadioButton *)_shuffle_bg->find(i); i++) {
      if (rb->isChecked()) {
         result = *_shuffle_list.at(i);
         break;
      }
   }
   return(result);
}

