/***************************************************************************
                          kbubbles.cpp  -  description
                             -------------------
    begin                : Fri Jan  7 21:41:10 CET 2000
    copyright            : (C) 2000 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbubbles.h"

// KDE
#include <QwSpriteField.h>

// QT
#include <qkeycode.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qcolor.h>
#include <qfont.h>
#include <qstring.h>
#include <qfile.h>

// OTHER
#include "bubble.h"
#include "kbubblesMain.h"
#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include "global.h"

#define SPEED 5

#define TIMER 8

#define BONUS 40000
/*
struct ballinfo {
	int x; // Column
	int y; // Row
	int color; 	// -1 = random, 1 =  red, 2 = green, 3 = black, 4 = white, 5 = magenta
							//  6 = grey this is a dead color, you can only get this color at startup
};

struct link_level {
   struct ballinfo level[60];
   link_level *prev;
   link_level *next;
};
*/
Kbubbles::Kbubbles(char *bkgImage,QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	this->grabKeyboard();
	this->setFixedSize(320,448);
	
	KbField = new QwImageSpriteField(bkgImage,320,448,64, 200);
		
	KbView = new QwSpriteFieldView(KbField,this);
	
  this->KbTextSp = NULL;
	this->angle = 0.0;

  this->createArrows();
		
	QList<QPixmap> lpm;
	QList<QPoint> lhs;

	QPixmap *pix[6];
	QPoint point(0,0);
	
	for (int i = 0; i < 6; i++) {
		pix[i] = new QPixmap(32,32,-1);
		this->createPixmap(*pix[i],i);
  	pix[i]->setMask(pix[i]->createHeuristicMask());
		lpm.append(pix[i]);
		lhs.append(&point);
	}
	KbPixSeq = new QwSpritePixmapSequence(lpm,lhs);
	QString bkg;
	bkg.sprintf("%s/kbubbles/bkg/widbg.xpm",kapp->kde_datadir().data());
	this->setBackgroundPixmap(bkg.data());
	bkg.sprintf("%s/kbubbles/bkg/roof.xpm",kapp->kde_datadir().data());
	QPixmap *roof = new QPixmap(bkg.data());
	QList<QPixmap> lpir;
	QList<QPoint> lpor;
	lpir.append(roof);
	lpor.append(&point);
	QwSprite *spRoof = new QwSprite(new QwSpritePixmapSequence(lpir,lpor));
  spRoof->moveTo(0,0);
  bubble = new Bubble(this,KbPixSeq, rand()%5);
	
	connect(bubble,SIGNAL(moveDownView()),this, SLOT(scrollView()));
	connect(bubble,SIGNAL(deletedBubbles(int)),this, SLOT(getDeletedBubbles(int)));
	bubble->moveDown = 0;	
	bubble->moveTo(arr->x()+16,arr->y()+16);
	
	bubble->bubList = new bubbleList();
}

//void Kbubbles::setupLevel(int level)
void Kbubbles::setupLevel(struct link_level l)
{
  Bubble *sp;
	bubbleList *tmpList;
	tmpList = bubble->bubList;
	
	int i = 0;
	for (i = 0; i < 6; i++)
		bubble->colorLeft[i] = 0;
	i=0;
	while (l.level[i].x != -1) {
		sp = new Bubble(this,KbPixSeq,
										(l.level[i].color == -1 ? rand()%5 :	l.level[i].color - 1),
										 l.level[i].x,
										 l.level[i].y );
		sp->lowestBubble = sp->y() > sp->lowestBubble ? sp->y() : sp->lowestBubble;
		tmpList = tmpList->add(sp);	
  	bubble->colorLeft[sp->color]++;
		if ( l.level[i].y == 0)
			sp->haveWall = 1;
		i++;
	}
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL) {
		tmpList->bub->checkInitFriend();
		tmpList = tmpList->getNext();
	}
	bubble->setupColors();

	scrollTimer = new QTimer();
	connect(scrollTimer,SIGNAL(timeout()),this, SLOT(scrollView()));
	bonusTime = new QTime();
	bonusTime->start();
	scrollTimer->start(10 * 1000);
  startTimer(TIMER);
	
}

void Kbubbles::scrollView()
{
	if (bubble->dY() == 0) {
		for (int i = 0; i < 8; i++)
			KbView->move(0, KbView->y() + 2);		
		arr->moveTo(arr->x(),arr->y()-16);
		bubble->moveTo(arr->x()+16,arr->y()+16);
		if (bubble->lowestBubble > arr->y()-16) {
			this->endLevel();
		}
	} else {
		bubble->moveDown = 1;
	}
}

void Kbubbles::createArrows()
{
  int i,j;
  double deg;
  int x_cen = 31;
  int y_cen = 31;
  int points[12][4] = { {0,0,0,-31},{1,0,0,-31},
				  							{-1,-22,0,-7},{2,-22,0,-7},
				  							{-2,-22,0,-4},{3,-22,0,-4},
												{-3,-22,0,-1},{4,-22,0,-1},
				  							{-4,-21,9,0},{-4,-20,9,0},
				  							{0,1,0,32},{1,1,0,32} };

  QPainter *paint = new QPainter();
  QPoint p;
	QList<QPixmap> lpm;
	QList<QPoint> lhs;
  QPixmap *arrow[71] = {NULL};
  QPoint point(0,0);
  i = 0;
  for (deg = -87.5; deg < 90; deg +=2.5) {
    arrow[i] = new QPixmap(64,64,-1);
    arrow[i]->fill(QColor::QColor("blue"));
    paint->begin(arrow[i]);
    paint->setPen(QColor::QColor("black"));	
    paint->rotate(deg);
    p.setX(x_cen);
    p.setY(y_cen);
    p = paint->xFormDev(p);
    for  (j = 0; j < 12;j++) {
      paint->drawLine(p.x()+points[j][0], p.y()+points[j][1],
		      p.x()+points[j][0]+points[j][2], p.y()+points[j][1]+points[j][3]);
    }
    paint->end();
  	arrow[i]->setMask(arrow[i]->createHeuristicMask());
		lpm.append(arrow[i]);
		lhs.append(&point);
    i++;
  }
  this->arr = new QwSprite( new QwSpritePixmapSequence(lpm,lhs) );
  this->arr->z(0);
  this->arr->frame(35);
  this->arr->moveTo(128,384);
}

void Kbubbles::keyReleaseEvent(QKeyEvent *key)
{
	if (KbTextSp != NULL && key->key() != 'P')
		return;
	switch (key->key()) {
	case Key_Right:
		if (this->angle < 87.5) {
			this->arr->frame(arr->frame() + 1);
			this->angle += 2.5;
		}
		break;
	case Key_Left:
		if (this->angle > -87.5) {
			this->arr->frame(arr->frame() - 1);
			this->angle -= 2.5;
		}
		break;
	case Key_Space:
		if (bubble->dY() == 0.0) {
			bubble->setVelocity(SPEED*sin(this->angle * 3.14/180.0),-SPEED*cos(this->angle * 3.14/180.0) );
		}
		break;
  case 'F':
  	this->endLevel();
  	break;
  case 'P':
  	if (scrollTimer->isActive()) {
  		this->pause();
  	} else {
  		this->upause();
  	}
  	break;
	default:
		break;
	}
}


void Kbubbles::timerEvent(QTimerEvent*)
{

//	Pix tmp;
//	QwSprite *sp;
	bubble->forward(1.0);
	KbField->update();
	qApp->syncX();
	if (bubble->y() <= 5) {
		killTimers();
		if (bubble->bubbleCollide()) {
			this->endLevel();
		  return;
		}
		startTimer(TIMER);
		return;
	}

	bubbleList *tmpList;
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL) {		
//		if (bubble->hitting(*(tmpList->bub))) {
		if ( 	(bubble->x()-tmpList->bub->x())*(bubble->x()-tmpList->bub->x())+
					(bubble->y()-tmpList->bub->y())*(bubble->y()-tmpList->bub->y()) < 30*30 ) {	
			killTimers();
			if (bubble->bubbleCollide()) {
				this->endLevel();
		 		return;
			}
			startTimer(TIMER);
			return;
		}
		tmpList = tmpList->getNext();
	}
}

void Kbubbles::getDeletedBubbles(int num)
{
	if (num > 10)
		num *= 5;  // some bonus
	emit updatePoints(num * 100);
}

void Kbubbles::endLevel()
{
//	this->releaseKeyboard();
	int res;
	killTimers();
	scrollTimer->stop();
	QFont font;
	font.setWeight(QFont::Bold);
	font.setPointSize(40);
	if (bubble->bubList->getNext() == NULL) {  // First always empty
		// Level completed succefully
		QString str;
		int bonus;
		if ((bonus = bonusTime->elapsed()) < BONUS) {
			str.sprintf("%s: %d",i18n("LEVEL DONE\nBONUS"),BONUS - bonus);
			emit updatePoints(BONUS - bonus);
		} else
			str.setStr(i18n("LEVEL DONE"));
		KbTextSp = new QwTextSprite();
		KbTextSp->setText(str.data());
		KbTextSp->setFont(font);
		KbTextSp->setColor(QColor::QColor("red"));
		KbTextSp->moveTo(0,200 - KbView->y());
		res = 1;
		cout << "BRA\n";
		delete bubble;
		KbField->update();
		qApp->syncX();
		::sleep(3);
	} else {
		// Failed to finish level
		// Need to free up memory from bubbels
		QString str;
		str.setStr(i18n("FAILED LEVEL"));
		KbTextSp = new QwTextSprite();
		KbTextSp->setText(str.data());
		KbTextSp->setFont(font);
		KbTextSp->setColor(QColor::QColor("red"));
		KbTextSp->z(10);
		KbTextSp->moveTo(0,200 - KbView->y());
		res = 0;
		cout << "Mindre bra\n";
		delete bubble;
		KbField->update();
		qApp->syncX();
		::sleep(3);
		while (bubble->bubList != NULL)
			bubble->bubList = bubble->bubList->remove();
	}
	cout << "outOfBubbles\n";
	delete KbView;
	delete KbField;
	emit result(res);
}

void Kbubbles::pause()
{
//	this->releaseKeyboard();
	if (KbTextSp != NULL)
		return;
	killTimers();
	scrollTimer->stop();
	QFont font;
	font.setWeight(QFont::Bold);
	font.setPointSize(60);
	KbTextSp = new QwTextSprite(i18n("PAUSE"),font);
	KbTextSp->setColor(QColor::QColor("red"));
	KbTextSp->moveTo(30,200);
	KbField->update();
}	
void Kbubbles::upause()
{
//	this->grabKeyboard();
	if (KbTextSp != NULL) {
		KbTextSp->visible(FALSE);
		delete KbTextSp;
		KbField->update();
		KbTextSp = NULL;
	}
	startTimer(TIMER);
	scrollTimer->start(10 * 1000);
}

Kbubbles::~Kbubbles()
{
}

void Kbubbles::createPixmap(QPixmap &pix, int color)
{
  char *colorName[7] = {"red", "green", "black", "white", "magenta", "grey"};
  int dia = (pix.width() < pix.height() ? pix.width() : pix.height());
  QColor qcolor("blue");
  pix.fill(QColor::QColor(colorName[color]));
  QPainter *paint = new QPainter();
  paint->begin(&pix);
  paint->setPen(qcolor);
  paint->drawEllipse(0, 0, dia,dia);
  paint->end();
  return;
}