/***************************************************************************
                          qrolistbox.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Sat May 1 1999                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qtextstream.h>
#include <qpainter.h>
#include "qrolistbox.h"

EditListBoxItem::EditListBoxItem(QListBox* parent,const char * Text)
		:QLineEdit(parent),QListBoxText(Text),par(parent)
{
	initMetaObject();
	setFrame(false);
	QString t(Text);
	t.stripWhiteSpace();
	setMaxLength(10);
	QLineEdit::setFixedHeight(14);
	QLineEdit::setText(t);
	setCursorPosition(t.length());
	setBackgroundColor(par->backgroundColor());
	setEnabled(false);
	connect(this,SIGNAL(ReturnPressed()),SLOT(slotReturnPressed()));
}

EditListBoxItem::~EditListBoxItem() {
}

void EditListBoxItem::paint(QPainter* p){
	p->setBackgroundColor(par->backgroundColor());
	QListBoxText::paint(p);
}

void EditListBoxItem::setPos(int p) {
//	QTextStream cout( stdout, IO_WriteOnly );
//	cout << "EditListBoxItem:setPos: " << height(par) << endl;
	setFont(par->font());
	setGeometry(2,2+p*(height(par)+2),90,height(par));
	
}

int EditListBoxItem::height(const QListBox*l){
//	QTextStream cout( stdout, IO_WriteOnly );
        int a=QListBoxText::height(l)-2;
//	cout << "EditListBoxItem:height: " << a << endl;
	return a;
}

int EditListBoxItem::width(const QListBox*l){
	return QListBoxText::width(l);
}

void EditListBoxItem::keyPressEvent ( QKeyEvent *e ) {
	if ((e->state()==0) && (e->ascii()==0x0d)) {
		e->accept();
		emit ReturnPressed();
	} else
	QLineEdit::keyPressEvent(e);
	e->accept();
}

void EditListBoxItem::slotReturnPressed(){
	QString o=QLineEdit::text();
        o.stripWhiteSpace();
	emit returnText(o);
}

QROListbox::QROListbox(QWidget * parent=0, const char * name=0, WFlags f=0 ):
            QListBox(parent,name,f) {
	initMetaObject();
	setScrollBar(false);
	setDragSelect(false);
	setFocusPolicy(QWidget::NoFocus);
}

QROListbox::~QROListbox(){
}

void QROListbox::mousePressEvent ( QMouseEvent * e )  {
}

void QROListbox::KeyPressEvent ( QKeyEvent * e )  {

}






























