/***************************************************************************
                          scoreboard.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Sun May 2 1999                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "scoreboard.h"
#include <qlabel.h>
#include <qstring.h>
#include <qdatetime.h>
#include <kapp.h>
#include <qtextstream.h>
#include <qlineedit.h>

Scoreboard::Scoreboard( QWidget *parent, const char* name,const char* game,const QStrList* level,
                        const int speed,const int score )
	   :QDialog( parent, name, TRUE ), Game(game),Level(level),Speed(speed),Score(score)
{
        initMetaObject();
        displayonly=false;
	init();
        getValues();
}

/** Aufruf Scoreboard zur Anzeige */
Scoreboard::Scoreboard(QWidget* parent,const char* name,const char* game,const QStrList* level,
                       const int speed)
	   :QDialog( parent, name, TRUE ), Game(game),Level(level),Speed(speed),Score(0)
{
        initMetaObject();
        displayonly=true;
        init();
        getValues();
}

void Scoreboard::init() {
	QLabel* t;
	QLabel* t2;
	QLabel* t3;
        t  = new QLabel(this,"t");
        t->setText(Game);
        t->setFont(QFont("fixed",14,QFont::Bold));
	t->setGeometry( 10,10, 130,20 );

        t2  = new QLabel(this,"t");
        t2->setFont(QFont("terminal",14,QFont::Bold));
        t2->setText(i18n(" Level"));
	t2->setGeometry( 90,10, 55,20 );

        cb = new QComboBox(false,this,"Combo");
	cb->setGeometry( 150,10, 160,20 );
        cb->insertStrList(Level);
        cb->setCurrentItem(Speed);
        connect(cb,SIGNAL(activated(int)),SLOT(slotLevelChanged(int)));

        t3  = new QLabel(this,"t");
        t3->setFont(QFont("terminal",14,QFont::Bold));
        t3->setText(i18n(" Name        Points    Date"));
	t3->setGeometry( 10,50, 300,20 );

	lb = new QROListbox(this,"score");
	lb->setGeometry( 10,70, 300,175 );
        lb->setFont(QFont("terminal",14));
        lb->setBackgroundColor(lightGray);
        lb->setAutoScroll(false);

	ok = new QPushButton( "Ok", this );
	ok->setGeometry( 10,255, 300,30 );
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );
	if (displayonly) ok->setDefault(true);
        setMaximumSize(320,295);
        setMinimumSize(320,295);
        setCaption(i18n("Highscore"));
	el=0;

}
void Scoreboard::show() {

	if (el) {
		el->setPos(insertpos);
		el->show();
		el->setFocus();
	}
	QDialog::show();

}
int Scoreboard::getValues() {
	QString entry,sc;
	QString key;
     	QStrList listentry;
	int i=0,j=0;
	bool inserted=false;
	lb->hide();
        lb->clear();
	KConfig *config = kapp->getConfig();
	config->setGroup(QString(Game).upper());
	player=config->readEntry("LastPlayer","");
        key.sprintf("i%u%02u",Speed,i);
	int c=config->readListEntry(key,listentry);
	insertpos=-1;
	while ((c) && (j<10)) {
		sl[j]=listentry;
		entry.sprintf("%-10s  %7s   %s",sl[j].at(0),sl[j].at(1),sl[j].at(2));
		EditListBoxItem* e=new EditListBoxItem(lb,entry);
		e->hide();
		if (!displayonly) {
			sc=sl[j].at(1);
			if ((Score>sc.toInt()) && !inserted) {
				sl[j+1]=listentry;
				inserted=true;
				insertpos=j;
				sl[j].clear();
				sl[j].insert(0,(const char*)player);
				QDate date=QDate::currentDate();
				sc.setNum(Score);
				sl[j].insert(1,(const char*)sc);
				sc.sprintf("%4u/%02u/%02u",date.year(),date.month(),date.day());
				sl[j].insert(2,(const char*)sc);
				sc.sprintf("%-10s  %7s   %s",sl[j].at(0),sl[j].at(1),sl[j].at(2));
				el=new EditListBoxItem(lb,sc);
				connect(el,SIGNAL(returnText(const char*)),SLOT(slotNameAccepted(const char*)));
				el->setEnabled(true);
				lb->insertItem(el);
				el->setPos(j);
				j++;	
                	}
		}
		if (j<10) {
			lb->insertItem(e);
			e->setPos(j);
		}
		entry="";
		listentry.clear();
		i++;j++;
		key.sprintf("i%u%02u",Speed,i);
		c=config->readListEntry(key,listentry);
        }

        if (!displayonly && (j<10) && (Score>0) && !inserted) {
		sl[j].insert(0,(const char*)player);
		QDate date=QDate::currentDate();
		sc.setNum(Score);
		sl[j].insert(1,(const char*)sc);
		sc.sprintf("%4u/%02u/%02u",date.year(),date.month(),date.day());
		sl[j].insert(2,(const char*)sc);
		sc.sprintf("%-10s  %7s   %s",sl[i].at(0),sl[i].at(1),sl[i].at(2));
		el=new EditListBoxItem(lb,sc);
		connect(el,SIGNAL(returnText(const char*)),SLOT(slotNameAccepted(const char*)));
		lb->insertItem(el);
		el->setEnabled(true);
		el->setPos(j);
		el->setFocus();
		insertpos=j;
		inserted=true;
		j++;
        }
	while (j<10) {
		j++;
		 lb->insertItem("    ");
	}
	config->setGroup("");
	lb->show();

	return insertpos;
}

void Scoreboard::slotLevelChanged(int speed) {
        if (!displayonly) {
		saveValues();
	}
        displayonly=true;
	Speed=speed;
        getValues();
}

void Scoreboard::slotNameAccepted(const char* t) {
	QTextStream cout( stdout, IO_WriteOnly );
	cout << "ScoreBoard.slotNameAccepted: " << t <<" " << lb->itemHeight(insertpos)<< endl;
	disconnect(el,SIGNAL(returnText(const char*)),this,SLOT(slotNameAccepted(const char*)));
	el->clearFocus();
        el=0;
	player=t;
	sl[insertpos].remove((uint) 0);
	sl[insertpos].insert(0,t);
	QString sc;

	sc.sprintf("%-10s  %7s   %s",sl[insertpos].at(0),sl[insertpos].at(1),sl[insertpos].at(2));
	EditListBoxItem* e=new EditListBoxItem(lb,sc);
	e->hide();
	lb->changeItem(e,insertpos);
	lb->update();
	lb->setSelected(insertpos,true);
	ok->setDefault(true);

}

void Scoreboard::saveValues() {
	QString key;
     	QStrList listentry;
	if(el) slotNameAccepted(el->QLineEdit::text());
	KConfig *config = kapp->getConfig();
	config->setGroup(QString(Game).upper());
	config->writeEntry("LastPlayer",player);
	for (int i=0;i<10; i++ ) {
	        key.sprintf("i%u%02u",Speed,i);
        	if (!(sl[i].isEmpty()))
	 		config->writeEntry(key,sl[i]);
	}
	config->sync();
	config->setGroup("");
}

Scoreboard::~Scoreboard(){
	if (!displayonly) saveValues();
}







































