/* computer_player.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef GO_COMPUTER_H
#define GO_COMPUTER_H

#include <qobject.h>
#include <qsignal.h>
#include "go_board.h"
#include "go_player.h"

// increase this to improve playing style 
#define MAXTRY 800

#include "patterns.h"

#define line(x) (abs(x-9))

/**
 * This class is the computer player of Kgo. The
 * code was mainly copied from gnugo. A few changes have
 * been made to connect the player to the KGoBoard.
 * @see KGoBoard
 * @see KGoPlayer
 *
 * @short This class represents a computer player.
 *
 **/
class KGoComputer : public KGoPlayer
{
	Q_OBJECT

public:
	KGoComputer( int color, KGoBoard *b, QWidget *parent=0,
		const char *name = 0 );
 	~KGoComputer();


public slots:
	void stateChange( int ) ;
	void boardSetup() ;
	void opponentMoved( int, int ) ;
	void illegalMove( int r, int p ) ;
	void setBoard( KGoBoard *b ) ;
signals:
	void doMove( int, int ) ;

protected:
	int load( QDataStream &, KGoBoard * ) ;
	int save( QDataStream & ) ;

	bool canBeSaved() ;

private:
	void initData( int color ) ;
	void makeMove() ;
	/* update the internal board with some other board */
	void updateFromBoard( KGoBoard * ) ;

	/* for debugging */
	void checkFields() ; 

	// from GNUGO

void genmove( int *, int * ) ;
void eval( int ) ;
void count(int i, int j, int color) ;
void countlib(int m, int n, int color) ;
unsigned int findcolor(int i, int j) ;
int suicide(int i, int j) ;
void examboard(int color) ;
void initmark() ;

int findnextmove(int m, int n, int *i, int *j,
		int *val, int minlib ) ;
int findopen(int m, int n, int i[], int j[], int color,
		int minlib, int *ct) ;
int findpatn(int *i, int *j, int *val) ;
int findsaver(int *i, int *j, int *val) ;
int findwinner(int *i, int *j, int *val) ;
int fioe(int i, int j) ;
int fval(int newlib, int minlib) ;
int openregion( int i1, int j1, int i2, int j2 ) ;

int matchpat(int m,   
             int n,    
             int *i,   
             int *j,   
             int *val)  ;

int opening(int *i,
            int *j,
            int *cnd,
            int type) ;

// int i, j ;

int xSize, ySize ;
unsigned char **p ;  /* go board */
unsigned char **l ;  /* liberty of current color */
unsigned char **ma ; /* working matrix for marking */
unsigned char **ml ; /* working matrix for marking */
int mymove, umove;        /* computer color, opponent color */
int lib;                  /* current stone liberty */
int play;                 /* game state */
int pass;                 /* pass indicator */
int mik, mjk;             /* location of computer stone captured */
int uik, ujk;             /* location of opponent stone captured */
int mk, uk;               /* no. of stones captured by computer and oppoent */
int opn[9];               /* opening pattern flag */

} ;
#endif
