/*
 * ktimer.h
 */

#ifndef KTIMER_H
#define KTIMER_H

#include <qdatetm.h>

#define RUNNING 0
#define STOPPED 1

/**
 * KTimer is a timer. It was written
 * to be used as a simple stopwatch.
 *
 * @short Simple timer
 */
class KTimer
{

public:
	KTimer();
	~KTimer() ;
	
public :

	/**
	 * Start the timer, reset to zero
	 **/
	void start();
	/**
	 * Stop the timer, reset to zero 
	 */
	void stop() ;

	/**
	 * Stop the timer 
	 */
	void freeze();
	/**
	 * Resume the timer 
	 */
	void resume() ;

	/**
	 * Set the timer to zero 
	 */
	void zero();

	/**
	 * Return the number of seconds since the timer started
	 */
	int getSeconds() ;

	/**
	 * This method returns the time since the timer started
	 *
	 * @return the number of miliseconds
	 */
	long getTime() ;

	/**
	 * Set the timer to a value.
	 *
	 * @param msecs The number of miliseconds the timer should be set to  
	 */
	void setTime( long msecs ) ;
	
	/**
	 * This method can be used to check if
	 * the timer is running
	 *
	 * @return true if the timer is running
	 */
	bool isRunning() ;

private:
	QTime *t ;
	long total ;
	int  state ;      /* state */
};


#endif
