#include <kgreditwidget.h>
#include <kgreditwidget.moc>

kgreditWidget::kgreditWidget(QWidget *parent, const char *name)
	: QWidget(parent, name)
{ 
  int i,j;
  int field_id;
  KIconLoader *loader = kapp->getIconLoader();
  
  activeObject = FREE;
  mouse_pressed = false;
  setFixedSize(512,384);
  resize(512,384);
  change = false;

  //   erzeuge das Spielfeld 
  for (i=0;i<20;i++)
    {
      for (j=0;j<28;j++)
	{
	  field_id = j+28*i;
	  board[j][i] = new kgreditField(field_id,
					 32+j*16,32+i*16,this);
	  connect(board[j][i],SIGNAL(setPressedStatus(bool)),SLOT(setMousePressed(bool)));
	  connect(board[j][i],SIGNAL(getPressedStatus(int)),SLOT(sendPressedStatus(int)));
	  connect(board[j][i],SIGNAL(getActivePix(int)),SLOT(sendActivePixmap(int)));
	  connect(board[j][i],SIGNAL(getActiveObject(int)),SLOT(sendActiveObject(int)));
	}
    }
  
  // lade die ObjectPixmaps 
  hero_pix = loader->loadIcon("chero.xpm",16,16);
  enemy_pix = loader->loadIcon("cenemy.xpm",16,16);
  brick_pix = loader->loadIcon("cbrick.xpm",16,16);
  fbrick_pix = loader->loadIcon("cfbrick.xpm",16,16);
  beton_pix = loader->loadIcon("cbeton.xpm",16,16);
  ladder_pix = loader->loadIcon("cladder.xpm",16,16);
  hladder_pix = loader->loadIcon("chladder.xpm",16,16);
  nugget_pix = loader->loadIcon("cnugget.xpm",16,16);
  pole_pix = loader->loadIcon("cpole.xpm",16,16);
  hgbrick_pix = loader->loadIcon("hgbrick.xpm",16,16);
  activePixmap = QPixmap(16,16);
}

kgreditWidget::~kgreditWidget()
{
  int i,j;

  for (i=0;i<20;i++)
    {
      for (j=0;j<28;j++)
	{
	  delete board[j][i];
	}
    }
}

void kgreditWidget :: clearBoard()
{
  int i,j;

  for (i=0;i<20;i++)
    {
      for (j=0;j<28;j++)
	{
	  board[j][i]->clean();
	}
    }
}

void kgreditWidget :: setchanged(bool t)
{
  change = t;
}

void kgreditWidget :: load(QFile &f)
{
  int i,j;
  
  for (i=0;i<20;i++)
    {
      for (j=0;j<28;j++)
	{
	  setActiveObject(f.getch()),
	  board[j][i]->setObject(activeObject);
	  board[j][i]->setPixmap(activePixmap);
	}
    }
}

void kgreditWidget :: save(QFile &f)
{
  int i,j;
  
  for (i=0;i<20;i++)
    {
      for (j=0;j<28;j++)
	{
	  f.putch(board[j][i]->getObject());
	}
    }
}

void kgreditWidget :: setActiveObject(unsigned char obj)
{ 
  activeObject=obj;
  switch(obj)
    {
    case HERO: activePixmap = hero_pix;break;
    case ENEMY: activePixmap = enemy_pix;break;
    case BRICK: activePixmap = brick_pix;break;
    case BETON: activePixmap = beton_pix;break;
    case FBRICK: activePixmap = fbrick_pix;break;
    case LADDER: activePixmap = ladder_pix;break;
    case HLADDER: activePixmap = hladder_pix;break;
    case NUGGET: activePixmap = nugget_pix;break;
    case POLE: activePixmap = pole_pix;break;
    default: activePixmap = hgbrick_pix;break;
    }
}

void kgreditWidget :: setObject(unsigned char obj,int x, int y)
{
  setActiveObject(obj);
  board[x][y]->setObject(obj);
  board[x][y]->setPixmap(activePixmap);
}

void kgreditWidget :: sendPressedStatus(int field)
{
  board[field%28][field/28]->setMousePressStatus(mouse_pressed);
}

void kgreditWidget :: sendActiveObject(int field)
{
  board[field%28][field/28]->setActiveObject(activeObject);
}

void kgreditWidget :: sendActivePixmap(int field)
{
  board[field%28][field/28]->setActivePixmap(activePixmap);
}

void kgreditWidget :: setMousePressed(bool pressed)
{
  mouse_pressed = pressed;
  if (!change)
    {
      change=true;
      changed(); //signal an kgredit
    }
}

