/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef Preferences_included
#define Preferences_included

#include <qwidget.h>
#include "prefgeneral.h"
#include "prefvideo.h"
#include "prefaudio.h"
#include "prefinput.h"
#include "prefgame.h"

class KTabCtl;
class QPushButton;
class QLineEdit;
class QLabel;

class Preferences : public QWidget
{
    Q_OBJECT

public:
    Preferences();
    ~Preferences() {}
    void readConfig();
    const QString optionString(const char *cname = 0);
    struct general_prefs prefGeneral;


signals:
    void commitChanges();
    void prefHide();
    void prefGameChanged();

protected slots:
    void ok();
    void apply();
    void cancel();

protected:
    void writeConfig();
    void closeEvent(QCloseEvent *e);
    void setPos(QLabel *lab, QLineEdit *le);
    void setDefaultConfig();

    QString     mamecmd;
    KTabCtl     *tabbar;
    QPushButton *b_ok;
    QPushButton *b_apply;
    QPushButton *b_cancel;
    
    PrefGeneral *prefgen;
    PrefVideo *prefvid;
    PrefAudio *prefaud;
    PrefInput *prefinp; 
    PrefGame *prefgam; 
   
    struct video_prefs prefVideo;
    struct audio_prefs prefAudio;
    struct input_prefs prefInput;
    struct game_prefs prefGame;
    
};
#endif // Preferences_included
