/**********************************************************************

	--- Qt Architect generated file ---

	File: prefgeneral.cpp
	Last generated: Wed Jul 15 14:46:51 1998

 *********************************************************************/

#include "prefgeneral.h"
#include <kapp.h>
#include <ksimpleconfig.h>

#define Inherited PrefGeneralData

PrefGeneral::PrefGeneral(QWidget* parent, const char* name)
	:Inherited( parent, name )
{
}

PrefGeneral::~PrefGeneral()
{
}


void PrefGeneral::setPrefs(struct general_prefs *prefs)
{
    checkCheat->setChecked(prefs->cheat);
    inputMamedir->setText(prefs->mamedir);
    inputSpooldir->setText(prefs->spooldir);
    inputMamecmd->setText(prefs->mamecmd);
    inputLogdir->setText(prefs->logdir);
}

void PrefGeneral::writeConfig(struct general_prefs *prefs, const char *cname)
{
    QString
        str,
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "General";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    config.writeEntry("cheat",checkCheat->isChecked());
    str = inputMamedir->text();
    if (!str.isEmpty())
        config.writeEntry("mamedir",inputMamedir->text());
    config.writeEntry("spooldir",inputSpooldir->text());
    QString
        cmd = inputMamecmd->text();
    if (!cmd.isEmpty() && cmd.find("@@Game") < 0) {
        cmd += " @@Game";
        inputMamecmd->setText(cmd);
    }
    if (cmd.isEmpty())
        cmd = "xmame @@Game";
    inputMamecmd->setText(cmd.data());
    config.writeEntry("mamecmd",inputMamecmd->text());
    config.writeEntry("logdir",inputLogdir->text());
}


void PrefGeneral::readConfig(struct general_prefs *prefs, const char *cname)
{
    QString
        str,
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "General";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("cheat"))
        prefs->cheat = config.readNumEntry("cheat");
    if (config.hasKey("mamedir")) {
        str = config.readEntry("mamedir");
        if (!str.isEmpty())
            prefs->mamedir = str;
    }
    if (config.hasKey("spooldir"))
        prefs->spooldir = config.readEntry("spooldir");
    if (config.hasKey("mamecmd"))
        prefs->mamecmd = config.readEntry("mamecmd");
    if (config.hasKey("logdir"))
        prefs->logdir = config.readEntry("logdir");
}


const QString PrefGeneral::optionString(struct general_prefs *prefs,
                                        const char *cname)
{
    QString
        opt = "",
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "General";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("cheat")) {
        if (prefs->cheat)
            opt += " -cheat";
    }
    if (config.hasKey("mamedir") && !prefs->mamedir.isEmpty()) {
        if (prefs->version > 33)
            opt += " -rompath ";
        else
            opt += " -mamedir ";
        opt += prefs->mamedir;
    }
    if (config.hasKey("spooldir") && !prefs->spooldir.isEmpty()) {
            opt += " -spooldir " + prefs->spooldir;
    }
    return opt;
}
