/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "prefvideo.h"
#include <kapp.h>
#include <ksimpleconfig.h>

#define Inherited PrefVideoData

PrefVideo::PrefVideo(QWidget* parent, const char* name)
	:Inherited( parent, name )
{
}


PrefVideo::~PrefVideo()
{
}


void PrefVideo::setPrefs(struct video_prefs *prefs)
{
    checkMitshm->setChecked(prefs->use_mitshm);
    checkXsync->setChecked(prefs->use_xsync);
    checkDirty->setChecked(prefs->use_dirty);
    checkPrivatcmap->setChecked(prefs->private_colormap);
    checkForcetruecolor->setChecked(prefs->force_truecolor);
    checkNorotate->setChecked(prefs->rotation);
    checkRor->setChecked(prefs->ror90);
    checkRol->setChecked(prefs->rol90);
    checkFlipX->setChecked(prefs->flip_Xaxis);
    checkFlipY->setChecked(prefs->flip_Yaxis);
    comboScale->setCurrentItem(prefs->heightscale);
    comboFrameskip->setCurrentItem(prefs->frameskip);
}

void PrefVideo::writeConfig(struct video_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Video";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (prefs->use_mitshm != checkMitshm->isChecked())
        config.writeEntry("use_mitshm",checkMitshm->isChecked());
    else
        config.deleteEntry("use_mitshm", false);
    if (prefs->use_xsync != checkXsync->isChecked())
        config.writeEntry("use_xsync",checkXsync->isChecked());
    else
        config.deleteEntry("use_xsync", false);
    if (prefs->use_dirty != checkDirty->isChecked())
        config.writeEntry("use_dirty",checkDirty->isChecked());
    else
        config.deleteEntry("use_dirty", false);
    if (prefs->private_colormap != checkPrivatcmap->isChecked())
        config.writeEntry("private_colormap",checkPrivatcmap->isChecked());
    else
        config.deleteEntry("private_colormap", false);
    if (prefs->force_truecolor != checkForcetruecolor->isChecked())
        config.writeEntry("force_truecolor",checkForcetruecolor->isChecked());
    else
        config.deleteEntry("force_truecolor", false);
    if (prefs->rotation != checkNorotate->isChecked())
        config.writeEntry("rotation",checkNorotate->isChecked());
    else
        config.deleteEntry("rotation", false);
    if (prefs->ror90 != checkRor->isChecked())
        config.writeEntry("ror90",checkRor->isChecked());
    else
        config.deleteEntry("ror90", false);
    if (prefs->rol90 != checkRol->isChecked())
        config.writeEntry("rol90",checkRol->isChecked());
    else
        config.deleteEntry("rol90", false);
    if (prefs->flip_Xaxis != checkFlipX->isChecked())
        config.writeEntry("flip_Xaxis",checkFlipX->isChecked());
    else
        config.deleteEntry("flip_Xaxis", false);
    if (prefs->flip_Yaxis != checkFlipY->isChecked())
        config.writeEntry("flip_Yaxis",checkFlipY->isChecked());
    else
        config.deleteEntry("flip_Yaxis", false);
    if (prefs->heightscale != comboScale->currentItem())
        config.writeEntry("heightscale",comboScale->currentItem());
    else
        config.deleteEntry("heightscale", false);
    if (prefs->frameskip != comboFrameskip->currentItem())
        config.writeEntry("frameskip",comboFrameskip->currentItem());
    else
        config.deleteEntry("frameskip", false);
}

void PrefVideo::readConfig(struct video_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Video";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("use_mitshm"))
        prefs->use_mitshm = config.readNumEntry("use_mitshm");
    if (config.hasKey("use_xsync"))
        prefs->use_xsync = config.readNumEntry("use_xsync");
    if (config.hasKey("use_dirty"))
        prefs->use_dirty = config.readNumEntry("use_dirty");
    if (config.hasKey("private_colormap"))
        prefs->private_colormap = config.readNumEntry("private_colormap");
    if (config.hasKey("force_truecolor"))
        prefs->force_truecolor = config.readNumEntry("force_truecolor");
    if (config.hasKey("rotation"))
        prefs->rotation = config.readNumEntry("rotation");
    if (config.hasKey("ror90"))
        prefs->ror90 = config.readNumEntry("ror90");
    if (config.hasKey("rol90"))
        prefs->rol90 = config.readNumEntry("rol90");
    if (config.hasKey("flip_Xaxis"))
        prefs->flip_Xaxis = config.readNumEntry("flip_Xaxis");
    if (config.hasKey("flip_Yaxis"))
        prefs->flip_Yaxis = config.readNumEntry("flip_Yaxis");
    if (config.hasKey("heightscale"))
        prefs->heightscale = config.readNumEntry("heightscale");
    if (config.hasKey("frameskip"))
        prefs->frameskip = config.readNumEntry("frameskip");
}

const QString PrefVideo::optionString(struct video_prefs *prefs, const char *cname)
{
    QString
        opt = "",
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Video";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("use_mitshm")) {
        if (prefs->use_mitshm)
            opt += " -mitshm";
        else
            opt += " -nomitshm";
    }
    if (config.hasKey("use_xsync")) {
        if (prefs->use_xsync)
            opt += " -xsync";
        else
            opt += " -noxsync";
    }
    if (config.hasKey("use_dirty")) {
        if (prefs->use_dirty)
            opt += " -dirty";
        else
            opt += " -nodirty";
    }
    if (config.hasKey("private_colormap")) {
        if (prefs->private_colormap)
            opt += " -privatecmap";
        else
            opt += " -noprivatecmap";
    }
    if (config.hasKey("force_truecolor")) {
        if (prefs->force_truecolor)
            opt += " -forcetruecolor";
        else
            opt += " -noforcetruecolor";
    }
    if (config.hasKey("rotation")) {
        if (prefs->rotation)
            opt += " -norotate";
    }
    if (config.hasKey("ror90")) {
        if (prefs->ror90)
            opt += " -ror";
    }
    if (config.hasKey("rol90")) {
        if (prefs->rol90)
            opt += " -rol";
    }
    if (config.hasKey("flip_Xaxis")) {
        if (prefs->flip_Xaxis)
            opt += " -flipx";
    }
    if (config.hasKey("flip_Yaxis")) {
        if (prefs->flip_Yaxis)
            opt += " -flipy";
    }
    if (config.hasKey("heightscale")) {
        QString
            s;
        s.sprintf("%d",prefs->heightscale+1);
        opt += " -scale " + s;
    }
    if (config.hasKey("frameskip")) {
        QString
            s;
        s.sprintf("%d",prefs->frameskip);
        opt += " -frameskip " + s;
    }
    return opt;
}
