/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qlist.h>
#include <qstring.h>

#include <kapp.h>

#include "qmylist.h"

const char *QMyListType::string(int len_name, int len_fullname)
{
    static QString
        str;

    str.resize(len_name+len_fullname+30);
    str.sprintf("%-*.*s %-*.*s   %-15.15s %2d",
            len_fullname, len_fullname, fn.data(),
            len_name, len_name, n.data(),
            getTypeString(), p);
    return str.data();
}

const char *QMyListType::getTypeString()
{
    switch(t) {
      case 0:
          return i18n("Action");
      case 1:
          return i18n("Jump&Run");
      case 2:
          return i18n("Shoot'em-up");
      case 3:
          return i18n("Sport");
      case 4:
          return i18n("Education");
      default:
          return i18n("Other");
    }
    // never get till here but, ...
    return i18n("Other");
}

int QMyList::compareItems(void *d1, void *d2)
{
    QString
        str1, str2;
    int
        num1, num2;
    QMyListType
        *l1 = (QMyListType *)d1,
        *l2 = (QMyListType *)d2;

    if (sm == SortName) {
        str1 = l1->name();
        str2 = l2->name();
    } else if (sm == SortNameFull) {
        str1 = l1->fullname();
        str2 = l2->fullname();
    } else if (sm == SortType) {
        num1 = l1->type();
        num2 = l2->type();
    } else if (sm == SortPriority) {
        num1 = l1->priority();
        num2 = l2->priority();
    } else {
        return strcmp(l1->fullname(),l2->fullname());
    }
    if ((sm == SortName) || (sm == SortNameFull))
        return strcmp(str1.data(),str2.data());
    if ((sm == SortType) || (sm == SortPriority)) {
        if (num1 == num2)
            return strcmp(l1->fullname(),l2->fullname());
        if (num1 < num2)
            return -1;
        else
            return 1;
    }
    return 0; // never arives here
}
