/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _MYLIST_H
#define _MYLIST_H

#include <qlist.h>
#include <qstring.h>

#define MAXTYPE 	5
#define MAXPRIORITY	9
class QMyListType
{
public:
    QMyListType()
        { n=0; fn=0; t = MAXTYPE; p = MAXPRIORITY;}
    QMyListType(const char *name,const char *fullname,int type,int priority)
        { n=name; fn = fullname; t = type; p = priority;}
    QMyListType(QMyListType *qmlt)
        { n=qmlt->name(); fn=qmlt->fullname();
          t=qmlt->type(); p=qmlt->priority();
        }
    void set(const char *name,const char *fullname,int type,int priority)
        { n=name; fn = fullname; t = type; p = priority;}
    const char *name() const
        { return n.data();}
    const char *fullname() const
        { return fn.data();}
    int type() const
        { return t;}
    int priority() const
        { return p;}
    const char *getTypeString();
    const char *string(int len_name, int len_fullname);
private:
    QString
        n, fn;
    int
        t, p;
};

#if defined(DEFAULT_TEMPLATECLASS)
typedef QListT<QMyListType>                    QMyListBase;
typedef QListIteratorT<QMyListType>            QMyListIterator;
#else
typedef Q_DECLARE(QListM,QMyListType)          QMyListBase;
typedef Q_DECLARE(QListIteratorM,QMyListType)  QMyListIterator;
#endif


class QMyList : public QMyListBase
{
public:
    enum SortMode { SortName, SortNameFull, SortType, SortPriority };
    QMyList() {sm = SortNameFull;}
    ~QMyList() { clear(); }
    void setSortMode(SortMode mode) { sm=mode; }
    SortMode sortMode() { return sm; }

private:
    SortMode
        sm;
    GCI   newItem( GCI d )
        { return new QMyListType((QMyListType*)d); }
    void  deleteItem( GCI d )
        { delete (QMyListType*)d; }
    int   compareItems( GCI d1, GCI d2 );
};

#endif
