/***************************************************************************
                          dlgmaproomproperties.h
                      -------------------
    description          : Room Properties Dialog Class
    begin                : Fri Apr 28 2000
    copyright            : (C) 2000 by John-Paul Stanford
    email                : john-paul.stanford@virgin.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DLGMAPOPTIONSPROPERTIES_H
#define DLGMAPOPTIONSPROPERTIES_H

#include <qtabdialog.h>

#include "dlgmaproomdescription.h"
#include "dlgmaproomapperance.h"
#include "dlgmaproomexits.h"


/**The properties for the rooms of the auto mapper
  *@author John-Paul Stanford
  */

class DlgMapRoomProperties : public QTabDialog {
	Q_OBJECT
public:
	/** constructor */
	DlgMapRoomProperties(QWidget *parent=0, const char *name=0);
	/** destructor */
	~DlgMapRoomProperties();
	
	void addExit(QString exit);
	int getNumExits(void);
	QString getExit(int index);
	
	QString getDescription(void);
	void setDescription(QString description);
	QString getLabel(void);
	void setLabel(QString label);
	
	QColor getColour(void);
	void setColour(QColor col);
	void setUseDefaultCol(bool b);
	bool getUseDefaultCol(void);
	
protected:
	QPushButton *ok_Button;
	QPushButton *cancel_Button;
	
	DlgMapRoomDescription *descriptionTab;
	DlgMapRoomApperance *apperanceTab;
	DlgMapRoomExits *exitsTab;		
};

#endif
