/***************************************************************************
                          dlgoptiongeneral.cpp
                          -------------------
    description          : General Options Dialog Class
    begin                : Thu Oct 7 1999
    copyright            : (C) 1999 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgoptiongeneral.h"

DlgOptionGeneral::DlgOptionGeneral(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
//    separator_LineEdit->setText(separator);
}

DlgOptionGeneral::~DlgOptionGeneral(){
}

bool DlgOptionGeneral::getKeepLastInput(){
	return keepLastInput_CheckBox->isChecked();
}

void DlgOptionGeneral::setKeepLastInput(bool b){
	return keepLastInput_CheckBox->setChecked(b);
}

bool DlgOptionGeneral::getUseBeep() {
	return useBeep_CheckBox->isChecked();
}

void DlgOptionGeneral::setUseBeep(bool u) {
	return useBeep_CheckBox->setChecked(u);
}

/** set's the intelligentHistory-Checkbox */
void DlgOptionGeneral::setIntelligentHistory(bool i)
{
	intelligentHistory_CheckBox->setChecked(i);
} // setIntelligentHistory

/** is intelligent history on or off? */
bool DlgOptionGeneral::getIntelligentHistory()
{
	return intelligentHistory_CheckBox->isChecked();
} // getIntelligentHistory

/** enables the Numpad for Macros */
void DlgOptionGeneral::setNumpadMacros(bool b)
{
	NumpadMacros_CheckBox->setChecked(b);
} // setNumpadMacros

/** returns if Numpad-Macros are enabled or disabled */
bool DlgOptionGeneral::getNumpadMacros()
{
	return NumpadMacros_CheckBox->isChecked();
} // getNumpadMacros

void DlgOptionGeneral::setSelectAllOnFocus(bool b)
{
	SelectAllOnFocus_CheckBox->setChecked(b);
}

bool DlgOptionGeneral::getSelectAllOnFocus()
{
	return SelectAllOnFocus_CheckBox->isChecked();
}
