/***************************************************************************
                          dlgoptionmemory.cpp
                          -------------------
    description          : Memory Options Dialog Class
    begin                : Sat Sep 11 1999
    copyright            : (C) 1999 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgoptionmemory.h"


DlgOptionMemory::DlgOptionMemory(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();

	connect( outputSize_Slider, SIGNAL(valueChanged(int)), outputSize_LCDNumber , SLOT(display(int)) );
	connect( inputSize_Slider, SIGNAL(valueChanged(int)), inputSize_LCDNumber , SLOT(display(int)) );
}

DlgOptionMemory::~DlgOptionMemory(){

	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()

}

int DlgOptionMemory::getOutputSize(){
	return outputSize_Slider->value();
}

int DlgOptionMemory::getInputSize(){
	return inputSize_Slider->value();
}

void DlgOptionMemory::setOutputSize(int i){
	outputSize_Slider->setValue(i);
}

void DlgOptionMemory::setInputSize(int i){
	inputSize_Slider->setValue(i);
}
