/*************************************************************************** 
                          dlgprofilealiases.cpp
                      -------------------
    description          :
    begin                : Mon Nov 1 1999
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgprofilealiases.h"
#include <qkeycode.h>
#include <X11/keysym.h>

DlgProfileAliases::DlgProfileAliases(KmudDoc* document, QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Aliases"));

	profile = document->getCharacterProfile(document->getCurrentCharacterID());
	profile->readAliases();
	
	initDialog();
	
	ProfileName_Label->setText(document->getCurrentCharacterID());

	aliases_ListView->addColumn( i18n("Alias Name") );
	aliases_ListView->addColumn( i18n("Macro") );
	aliases_ListView->addColumn( i18n("Definition") );
	aliases_ListView->setAllColumnsShowFocus( true );
	aliases_ListView->setColumnWidth(0, 100);
	aliases_ListView->setColumnWidth(1, 150);
	aliases_ListView->setColumnWidth(2, aliases_ListView->width()-100-150); // take the rest
	aliases_ListView->setColumnWidthMode(0, QListView::Manual);
	aliases_ListView->setColumnWidthMode(1, QListView::Manual);
	aliases_ListView->setColumnWidthMode(2, QListView::Manual);


	connect( cancel_Button, SIGNAL(clicked()), SLOT(slotCancelPressed()) );
	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( new_Button, SIGNAL(clicked()), SLOT(slotNewPressed()) );
	connect( delete_Button, SIGNAL(clicked()), SLOT(slotDeletePressed()) );
	connect( aliases_ListView, SIGNAL(selectionChanged(QListViewItem*)), SLOT(slotShowItem(QListViewItem*)) );
//	connect( change_Button, SIGNAL(clicked()), SLOT(slotChangePressed()) );
	connect( apply_Button, SIGNAL(clicked()), SLOT(slotApplyPressed()) );
    		
	if (profile == NULL) {
		aliases_ListView->clear();
		QListViewItem a = new QListViewItem(aliases_ListView, "", "", QString("NO ACTIVE PROFILE"));
		return;
	}
	updateListView();
	
	
	if (aliases_ListView->firstChild() != NULL) {
		aliases_ListView->setSelected(aliases_ListView->firstChild(), true);
	}
}

DlgProfileAliases::~DlgProfileAliases(){
}

void DlgProfileAliases::setDialogState() {
	QListViewItem* item;
	item = aliases_ListView->firstChild();
	bool flag=item!=NULL;
	delete_Button->setEnabled(flag);
	apply_Button->setEnabled(flag);
}


/** Updates the List View of all the aliases */
void DlgProfileAliases::updateListView() {
	QListViewItem* item;
	AliasEntry* alias;

	aliases_ListView->clear();
	alias = profile->firstAlias();

	while (alias != NULL) {
		item = new QListViewItem(aliases_ListView, alias->name, translateKey (alias->macro, alias->modifiers), alias->definition);
		alias = profile->nextAlias();
	}
}

/**                 **
 **    S L O T S    **
 **                 **/

/** When "OK" is pressed */
void DlgProfileAliases::slotOKPressed(){
	profile->writeAliases();
	accept();
}

/** When "CANCEL" is pressed */
void DlgProfileAliases::slotCancelPressed(){
	reject();
}

/** When "NEW" is pressed */
void DlgProfileAliases::slotNewPressed(){
	DlgProfileAliasesInput d(this,"New Alias");
	QListViewItem* item;
	AliasEntry * tmpAlias;
	bool set_macro = true;

	if(d.exec()) {
		if(d.getAlias() == "" ) {
			QMessageBox::information(this, i18n("Warning"), i18n("The aliasname is empty. No alias added."));
			return;
		}
		item = aliases_ListView->firstChild();
		while (item != NULL) {
			tmpAlias = profile->getAlias(QString(item->text(0)));
			if ( tmpAlias->name == d.getAlias() ) {
				QMessageBox::information(this, i18n("Warning"), i18n("That Alias is already in use. No alias added."));
				return;
			}
			if ( tmpAlias->macro == d.getMacro() && tmpAlias->macro!=0 && tmpAlias->modifiers == d.getModifiers() ) {
				QMessageBox::information(this, i18n("Warning"), i18n("That macro key is already in use. Not applying the macro setting!"));
				set_macro = false;
			}
			item = item->nextSibling();
		}
		if(set_macro)
			profile->insertAlias(d.getAlias(),d.getDefinition(),d.getMacro(), d.getModifiers());
		else
			profile->insertAlias(d.getAlias(),d.getDefinition(),0, NoButton);
		updateListView();
		
		if (aliases_ListView->firstChild() != NULL)
			aliases_ListView->setSelected(aliases_ListView->firstChild(), true);

	}
	setDialogState();
}

/** When "DELETE" is pressed */
void DlgProfileAliases::slotDeletePressed(){
	QListViewItem* item;

	item = aliases_ListView->firstChild();

	while (item != NULL) {
		if (aliases_ListView->isSelected(item)){
			profile->removeAlias(QString(item->text(0)));
			break;
		}
		item = item->nextSibling();
	}
	updateListView();

	if (aliases_ListView->firstChild() != NULL) 
		aliases_ListView->setSelected(aliases_ListView->firstChild(), true);
	setDialogState();
}


void DlgProfileAliases::slotShowItem(QListViewItem* item){
	AliasEntry* a;
	QString n, d;

	a = profile->getAlias(QString(item->text(0)));
	if (a == NULL) 
		return;

	n = item->text(0);
	d = item->text(2);
}

/** When "APPLY" is pressed */
void DlgProfileAliases::slotApplyPressed(){
	QListViewItem* item;
	AliasEntry* alias = NULL, *tmpAlias;
	bool set_macro = true,set_alias=true;

	// seek the selected alias
	item = aliases_ListView->firstChild();
	if(item == NULL ) {
		QMessageBox::information(this, i18n("Warning"), i18n("There are no aliases to edit!"));
		return;
	}
	while (item != NULL) {
		if (aliases_ListView->isSelected(item))
			alias = profile->getAlias(QString(item->text(0)));
		item = item->nextSibling();
	}
	if(alias == NULL) {
		QMessageBox::information(this, i18n("Warning"), i18n("You must select an alias before you can edit it."));
		return;
	}


	DlgProfileAliasesInput d(this,"Edit Alias");
	d.setAlias( alias->name );
	d.setDefinition( alias->definition );
	d.setMacro( alias->macro );
	d.setModifiers( alias->modifiers );
//	d.setGroupTitle("Edit Alias");

	if(d.exec()) {
		item = aliases_ListView->firstChild();
		while (item != NULL) {
			tmpAlias = profile->getAlias(QString(item->text(0)));
			if ( tmpAlias->name == d.getAlias() && alias!=tmpAlias) {
				QMessageBox::information(this, i18n("Warning"), i18n("That Alias is already in use."));
				set_alias=false;
				break;
			}
			if ( tmpAlias->macro == d.getMacro() && alias != tmpAlias && tmpAlias->macro!=0 && tmpAlias->modifiers == d.getModifiers()) {
				QMessageBox::information(this, i18n("Warning"), i18n("That macro key is already in use. Not changing the macro setting!"));
				set_macro = false;
				break;
			}
			item = item->nextSibling();
		}
		if (set_alias){
			alias->name = d.getAlias();
			alias->definition = d.getDefinition();
      if (set_macro) {
        alias->macro = d.getMacro();
        alias->modifiers = d.getModifiers();
      } else {
        alias->macro = 0;
        alias->modifiers = NoButton;
      }
		}
		updateListView();
	}
}

void DlgProfileAliases::slotChangePressed() {
	AliasEntry* a;
	QListViewItem* item;
	QString n, d;

	item = aliases_ListView->firstChild();
	a = NULL;
	while (item != NULL) {
		if (aliases_ListView->isSelected(item))
			a = profile->getAlias(QString(item->text(0)));
		item = item->nextSibling();
	}

	if (a == NULL) return;

	n = a->name;
	d = a->definition;
	DlgProfileMacros dlg(this, "Macros");

	if (dlg.exec())
	{
	}

	slotShowItem(aliases_ListView->currentItem());
	updateListView();

	item = aliases_ListView->firstChild();
	while (item != NULL) {
		if ((QString(item->text(0)) == QString(n)) && (QString(item->text(2)) == QString(d)) )
			aliases_ListView->setSelected(item, true);		
		item = item->nextSibling();
	}
}


/**
* translates the numeric key values into a human (user) readable String representation.
*/
QString DlgProfileAliases::translateKey(int key, ButtonState modifiers)
{
  QString result("");

  if (modifiers & ControlButton) {
    result.append(i18n("CTRL"));
    result.append(" ");
  } else {
    result.append("");
  }

  if (modifiers & AltButton) {
    result.append(i18n("ALT"));
    result.append(" ");
  } else {
    result.append("");
  }

  if (modifiers & ShiftButton) {
    result.append(i18n("SHIFT"));
    result.append(" ");
  } else {
    result.append("");
  }

	switch (key) {
		case Key_F2:
      result.append("F2");
			return result;
		case Key_F3:
      result.append("F3");
			return result;
		case Key_F4:
      result.append("F4");
			return result;
		case Key_F5:
      result.append("F5");
			return result;
		case Key_F6:
      result.append("F6");
			return result;
		case Key_F7:
      result.append("F7");
			return result;
		case Key_F8:
      result.append("F8");
			return result;
		case Key_F9:
      result.append("F9");
			return result;
		case Key_F10:
      result.append("F10");
			return result;
		case Key_F11:
      result.append("F11");
			return result;
		case Key_F12:
      result.append("F12");
			return result;
		case XK_KP_1:
      result.append("KP_1");
			return result;
		case XK_KP_2:
      result.append("KP_2");
			return result;
		case XK_KP_3:
      result.append("KP_3");
			return result;
		case XK_KP_4:
      result.append("KP_4");
			return result;
		case XK_KP_5:
      result.append("KP_5");
			return result;
		case XK_KP_6:
      result.append("KP_6");
			return result;
		case XK_KP_7:
      result.append("KP_7");
			return result;
		case XK_KP_8:
      result.append("KP_8");
			return result;
		case XK_KP_9:
      result.append("KP_9");
			return result;
		case XK_KP_0:
      result.append("KP_0");
			return result;
		case XK_KP_Equal:
      result.append("=");
			return result;
		case XK_KP_Multiply:
      result.append("*");
			return result;
		case XK_KP_Add:
      result.append("+");
			return result;
		case XK_KP_Separator:
      result.append(",");
			return result;
		case XK_KP_Subtract:
      result.append("-");
			return result;
		case XK_KP_Decimal:
      result.append(",");
			return result;
		case XK_KP_Divide:
      result.append("/");
			return result;
		case 0:
			return QString("None");
		default:
			return QString("ERROR");
	}
}
