/***************************************************************************
                          main.cpp  -  description                              
  	                           -------------------
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qobject.h>
#include "kmud.h"
#include "kmudapplication.h"

void HelpMsg(void)
{
	printf(i18n ("Please visit http://www.kmud.de for the latest version and other information.\n\n"));
	printf(i18n ("kmud [--help | --version | --host <host> --port <port> | \n"));
	printf(i18n ("      --wizard <character@mud title> ]\n\n"));
	printf(i18n ("Options:\n"));
	printf(i18n ("-h, --help                   Show this help.\n"));
	printf(i18n ("-v, --version                Show kmud version\n"));
	printf(i18n ("-h <host>, --host <host>     Connect to specified host\n"));
	printf(i18n ("-p <port>, --port <port>     Connect to specified port\n"));
	printf(i18n ("-w , --wizard                Connect to specified mud wizard entry\n\n"));
	printf(i18n ("Examples:\n"));
	printf(i18n ("   kmud -w \"Sunbright@Midnight Sun\"\n"));
	printf(i18n ("   kmud --wizard Sunbright@WOW\n"));
	printf(i18n ("   kmud --host midnight-sun.ludd.luth.se --port 3000\n\n"));
}

int main(int argc, char* argv[]) {

	// third parameter must be "kmud" (not "Kmud" or anything else)
	// it's the application name for KApplication and for exaple KIconloader
	// looks in directories like <appname>/toolbar to find our Icons
	// which fails when it's not named "kmud" here...
	KmudApplication app(argc,argv,"kmud");

	// Deal with CLI information parameters

	// Check to see if there are any parameters
	if (app.argc()>1)
	{
		// Check to see that the given parameter is valid
		if (strcmp(app.argv()[1], i18n ("--version")) &&
			strcmp(app.argv()[1], i18n ("--host")) &&
			strcmp(app.argv()[1], i18n ("--port")) &&
			strcmp(app.argv()[1], i18n ("--wizard")) &&
			strcmp(app.argv()[1], i18n ("--help")) &&
			strcmp(app.argv()[1], i18n ("-v")) &&
			strcmp(app.argv()[1], i18n ("-h")) &&
			strcmp(app.argv()[1], i18n ("-p")) &&
			strcmp(app.argv()[1], i18n ("-w")) &&
			strcmp(app.argv()[1], i18n ("-h")))
		{
			printf(i18n ("Invalid Parameters!\n"));
			HelpMsg();
			return 0;
		}

		if (!strcmp(app.argv()[1],i18n ("--version")) || !strcmp(app.argv()[1], i18n ("-v")))
		{
			printf("\nKMud Version %s\n\n",VERSION);
			return 0;			
		}

		if ((!strcmp(app.argv()[1], i18n ("--help")) || !strcmp(app.argv()[1], i18n ("-h"))) && app.argc()==2)
		{
			HelpMsg();
			return 0;
		}
	}

	if (app.isRestored())
	{
		RESTORE(KmudApp);
	}
	else
	{
		KmudApp* kmud = new KmudApp ();

		// Check to see if any CLI parameters have been given
		if (app.argc()>1)
		{
			if ((!strcmp(app.argv()[1], i18n ("--host")) || !strcmp(app.argv()[1], i18n ("-h"))) && app.argc()>2)
			{
				if ((!strcmp(app.argv()[3], i18n ("--port")) || !strcmp(app.argv()[3], i18n ("-p"))) && app.argc()==5)
				{
					kmud->connectToMud("","",app.argv()[2],app.argv()[4]);
				}
				else
				{
					kmud->connectToMud("","",app.argv()[2],"23");
				}
			}
			if ((!strcmp(app.argv()[1], i18n ("--port")) || !strcmp(app.argv()[1], i18n ("-p"))) && app.argc()==5)
			{
				if (!strcmp(app.argv()[3], i18n ("--host")) || !strcmp(app.argv()[3], i18n ("-h")))
					kmud->connectToMud("","",app.argv()[4],app.argv()[2]);
				else
				{
					printf(i18n ("Invalid Parameters!\n"));
					HelpMsg();
					return 0;
				}
			}

			if (!strcmp(app.argv()[1], i18n ("--wizard")) || !strcmp(app.argv()[1], i18n ("-w")))
			{
				if (app.argc()==3)
					kmud->connectWizardId(app.argv()[2]);	
				else
				{
					printf(i18n ("Invalid Parameters!\n"));
					HelpMsg();
					return 0;
				}
			}
		}

		kmud->show();
	}
	return app.exec();
}
