/***************************************************************************
                          plgtemplate.h
                      -------------------
    description          :
    begin                : Mon May 15 2000
    copyright            : (C) 2000 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PLGTEMPLATE_H
#define PLGTEMPLATE_H

#include "../../kmudplugin.h"

/**
	* template plugin for Kmud
	* use this as a basis for your plugin
  *@author Stephan Uhlmann
  */

class PlgTemplate : public KmudPlugin  {

public:

	/* constructor */
	PlgTemplate();

	/* destructor */
	~PlgTemplate();


	/* method called to start the plugin
	 * must be implemented
	 */
	void start();

	/* method called to stop the plugin
	 * must be implemented
	 */
	void stop();


	/* method called to process user input
	 * take the incoming QString and modify as you wish
	 * don't implement if not needed (delete method from your class)
	 */
	QString processInput(QString);

	/* method called to process raw mud output(as it comes from the mud
	 * with all ANSI codes etc.)
	 * take the incoming QString and modify as you wish
	 * don't implement if not needed (delete method from your class)
	 */
	QString processRawOutput(QString);

	/* method called to process parsed mud output(after it went through
	 * Kmud's filters for filtering out ANSI codes etc.
	 * take the incoming QString and modify as you wish
	 * don't implement if not needed (delete method from your class)
	 */
	QString processParsedOutput(QString);

	/* method called if user wants to configure the plugin
	 * (configure button in plugin manager)
	 * here you can popup your configuration dialog
	 * don't implement if not needed (delete method from your class) but
	 * leave KmudPlugin::configurable false.
	 */
	void callConfigDialog();

};

#endif
