#ifndef FELD_H
#define FELD_H

static const int STRASSEN          =  1;
static const int BAHNHOEFE         =  2;
static const int EREIGNISFELD      =  3;
static const int GEMEINSCHAFTSFELD =  4;
static const int STEUERFELD        =  5;
static const int GEFAENGNIS        =  6;
static const int FREIPARKEN        =  7;
static const int GEHINSGEFAENGNIS  =  8;
static const int LOS               =  9;
static const int WERKE             = 10;

#include <qobject.h>
#include <qstring.h>
#include <qmessagebox.h>
#include "strasse.h"
#include "feldDaten.h"
#include "spieler.h"
#include "bahnhof.h"

class Feld : public QObject
{
    Q_OBJECT
public:
    Feld();

    QString besitzer( QString name );
    bool    miete ( QString name, int feldNr );
    int     typ ( QString name );
    int     farbe ( QString name );
    int	    ID ( QString name );
    int     ID2 ( QString name );
    bool    kaufbar ( int feldNr );
    int     gebaeude ( QString name );
    QString name ( int feldNr );
    
public slots:
    bool    bauen ( QString name, int gebaeude );
    bool    kaufen ( QString name, int feldNr );
    void    hypothek( QString name );

signals:
    void  updated ();

private:
};

#endif // BALL_H
