#include "feldWidget.h"

FeldWidget::FeldWidget (QWidget *parent, int orient, int id) : QFrame (parent, "") {
    d3 = "";
    
    titel = fDaten[id].name;
    int    farbe = fDaten[id].farbe;
    int    typ   = fDaten[id].typ;
    int    wert  = fDaten[id].wert;
        
    switch (farbe) {
        case 1: { f = darkMagenta; break; };
        case 2: { f = cyan; break; };
        case 3: { f = magenta; break; };
        case 4: { f = darkYellow; break; };
        case 5: { f = red; break; };
        case 6: { f = yellow; break; };
        case 7: { f = darkGreen; break; };
        case 8: { f = blue; break; };
    };
    
    
    if (typ == LOS) {
	setBackgroundPixmap ("los.xpm");
    } else {
	setBackgroundColor (QColor (110, 255, 160));
    };
    
    if (titel.contains ("platz")) {
	d1 = titel.left (titel.find ("platz")) + "-";
	d2 = "platz";
    };
    if (titel.contains ("strasse")) {
	d1 = titel.left (titel.find ("strasse")) + "-";
	d2 = "strasse";
    };
    if (titel.contains (" Strasse")) {
	d1 = titel.left (titel.find (" Strasse"));
	d2 = "Strasse";
    };
    if (titel.contains ("bahnhof")) {
	d1 = titel.left (titel.find ("bahnhof")) + "-";
	d2 = "bahnhof";
    };
    if (titel.contains ("werk")) {
	d1 = titel.left (titel.find ("werk")) + "-";
	d2 = "werk";
    };
    if (titel.contains ("feld")) {
	if (titel.contains ("Gemeinschafts")) {
	    d1 = "Gemein-";
	    d2 = "schafts-";
	    d3 = "feld";
	} else {
	    d1 = titel.left (titel.find ("feld")) + "-";
	    d2 = "feld";
	};
    };
    if (titel.contains ("steuer")) {
	d1 = titel.left (titel.find ("steuer")) + "-";
	d2 = "steuer";
    };
    if (titel.contains ("allee")) {
	d1 = titel.left (titel.find ("allee")) + "-";
	d2 = "allee";
    };
    
    switch (orient) {
	case 1: {
		    setFrameStyle (Box | QFrame::Raised);
		    setFixedSize (50, 70);
    
		    if (typ == STRASSEN) {
			r1.setRect (2, 2, 46, 18);
			r7.setRect (2, 10, 11, 10);
			r8.setRect (13, 10, 11, 10);
			r9.setRect (24, 10, 11, 10);
			r10.setRect (35, 10, 11, 10);
		    };
		    
		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r2.setRect (2, 22, 46, 12);
			r3.setRect (2, 34, 46, 12);
		    } else {
			if (d3 == "") {
			    r2.setRect (2, 23, 46, 12);
			    r3.setRect (2, 35, 46, 12);
			} else {
			    r2.setRect (2, 17, 46, 12);
			    r3.setRect (2, 29, 46, 12);
			    r4.setRect (2, 41, 46, 12);
			};
		    };
    
		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r5.setRect (2, 50, 46, 18);
			r6.setRect (4, 4, 14, 6);
		    };
		    
		    break;
		};
	case 2: {
		    setFrameStyle (Box | QFrame::Raised);
		    setFixedSize (70, 50);
    
		    if (typ == STRASSEN) {
			r1.setRect (50, 2, 18, 46);
			r7.setRect (50, 4, 11, 10);
			r8.setRect (50, 14, 11, 10);
			r9.setRect (50, 24, 11, 10);
			r10.setRect (50, 34, 11, 10);
		    };
		    
		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r2.setRect (2, 2, 46, 12);
			r3.setRect (2, 14, 46, 12);
		    } else {
			if (d3 == "") {
			    r2.setRect (2, 13, 46, 12);
			    r3.setRect (2, 25, 46, 12);
			} else {
			    r2.setRect (2, 7, 46, 12);
			    r3.setRect (2, 19, 46, 12);
			    r4.setRect (2, 31, 46, 12);
			};
		    };
		    
		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r5.setRect (2, 34, 46, 14);
			r6.setRect (60, 4, 6, 14);
		    };
		    
		    break;
		};
	case 3: {
		    setFrameStyle (Box | QFrame::Raised);
		    setFixedSize (50, 70);
    
		    if (typ == STRASSEN) {
			r1.setRect (2, 50, 46, 18);
			r7.setRect (2, 50, 11, 10);
			r8.setRect (13, 50, 11, 10);
			r9.setRect (24, 50, 11, 10);
			r10.setRect (35, 50, 11, 10);
		    };

		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r2.setRect (2, 4, 46, 12);
			r3.setRect (2, 16, 46, 12);
		    } else {
			if (d3 == "") {
			    r2.setRect (2, 23, 46, 12);
			    r3.setRect (2, 35, 46, 12);
			} else {
			    r2.setRect (2, 17, 46, 12);
			    r3.setRect (2, 29, 46, 12);
			    r4.setRect (2, 41, 46, 12);
			};
		    };
    
		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r5.setRect (2, 32, 46, 18);
			r6.setRect (4, 60, 14, 6);
		    };
		    break;
		};
	case 4: {
		    setFrameStyle (Box | QFrame::Raised);
		    setFixedSize (70, 50);
    
		    if (typ == STRASSEN) {
			r1.setRect (2, 2, 18, 46);
			r7.setRect (9, 4, 11, 10);
			r8.setRect (9, 14, 11, 10);
			r9.setRect (9, 24, 11, 10);
			r10.setRect (9, 34, 11, 10);
		    };
		    
		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r2.setRect (22, 2, 46, 12);
			r3.setRect (22, 14, 46, 12);
		    } else {
			if (d3 == "") {
			    r2.setRect (22, 13, 46, 12);
			    r3.setRect (22, 25, 46, 12);
			} else {
			    r2.setRect (22, 7, 46, 12);
			    r3.setRect (22, 19, 46, 12);
			    r4.setRect (22, 31, 46, 12);
			};
		    };
		    
		    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
			r5.setRect (22, 34, 46, 14);
			r6.setRect (4, 4, 6, 14);
		    };
		    
		    break;
		};
    };

    if (typ == STRASSEN) {
	titelFrame = new QFrame (this);
	titelFrame->setGeometry (r1);
	titelFrame->setBackgroundColor (f);
	titelFrame->setFrameStyle (Box | Plain);
    };
    
    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {	
	bes = new QFrame (this);
	bes->setFrameStyle (QFrame::WinPanel | QFrame::Sunken);
	bes->setGeometry (r6);
	bes->hide ();
    };
		    
    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
	titelLabel = new QLabel (this);
	titelLabel->setGeometry (r2);
	titelLabel->setText (d1);
	titelLabel->setFont (QFont ("latin1", 8));
	titelLabel->setBackgroundColor (QColor (110, 255, 160));
	titelLabel->setAlignment (AlignCenter);
    
	titelLabel = new QLabel (this);
	titelLabel->setGeometry (r3);
	titelLabel->setText (d2);
	titelLabel->setFont (QFont ("latin1", 8));
	titelLabel->setBackgroundColor (QColor (110, 255, 160));
	titelLabel->setAlignment (AlignCenter);
    } else {
	if ((typ != LOS) && (typ != GEFAENGNIS) && (typ != FREIPARKEN) && (typ != GEHINSGEFAENGNIS)) {
	    if (d3 == "") {
		titelLabel = new QLabel (this);
		titelLabel->setGeometry (r2);
		titelLabel->setText (d1);
		titelLabel->setFont (QFont ("latin1", 10));
		titelLabel->setBackgroundColor (QColor (110, 255, 160));
		titelLabel->setAlignment (AlignCenter);
		    
		titelLabel = new QLabel (this);
		titelLabel->setGeometry (r3);
		titelLabel->setText (d2);
		titelLabel->setFont (QFont ("latin1", 10));
		titelLabel->setBackgroundColor (QColor (110, 255, 160));
		titelLabel->setAlignment (AlignCenter);
	    } else {
		titelLabel = new QLabel (this);
		titelLabel->setGeometry (r2);
		titelLabel->setText (d1);
		titelLabel->setFont (QFont ("latin1", 10));
		titelLabel->setBackgroundColor (QColor (110, 255, 160));
		titelLabel->setAlignment (AlignCenter);
	    
		titelLabel = new QLabel (this);
		titelLabel->setGeometry (r3);
		titelLabel->setText (d2);
		titelLabel->setFont (QFont ("latin1", 10));
		titelLabel->setBackgroundColor (QColor (110, 255, 160));
		titelLabel->setAlignment (AlignCenter);
			    
		titelLabel = new QLabel (this);
		titelLabel->setGeometry (r4);
		titelLabel->setText (d3);
		titelLabel->setFont (QFont ("latin1", 10));
		titelLabel->setBackgroundColor (QColor (110, 255, 160));
		titelLabel->setAlignment (AlignCenter);
	    };
	};
    };
    
    if ((typ == STRASSEN) || (typ == BAHNHOEFE) || (typ == WERKE)) {
	titelLabel = new QLabel (this);
	titelLabel->setGeometry (r5);
	d1.setNum (wert);
	titelLabel->setText (d1 + ",-");
	titelLabel->setFont (QFont ("latin1", 10, QFont::Bold));
	titelLabel->setBackgroundColor (QColor (110, 255, 160));
	titelLabel->setAlignment (AlignCenter);
    };
		    
    if ((typ == GEFAENGNIS) || (typ == LOS) || (typ == FREIPARKEN) || (typ == GEHINSGEFAENGNIS)) {
	setFixedSize (70, 70);
    };

};

void FeldWidget:: besitzer (int id) {
    QColor c;
    
    switch (id) {
	case 1: { c = black; break; };
	case 2: { c = yellow; break; };
	case 3: { c = green; break; };
	case 4: { c = red; break; };
    };
    
    bes->setBackgroundColor (c);
    bes->show ();
};
