#include "mainWidget.h"

QString      n, s;
besitzReturn t;
Spieler*     mSpieler;
QListBox*    lbl;
QListBox*    lbm;

MyMainWidget::MyMainWidget (const char *name) : KTopLevelWidget (name) {
    setFixedSize ( 610, 630 );

    fileMenu = new KPopupMenu ("File operations");
    CHECK_PTR (fileMenu);
    fileMenu->insertItem ("Exit", this, SLOT (quitProg()));
    
    menuBar = new KMenuBar (this);
    CHECK_PTR (menuBar);
    menuBar->insertItem ("File", fileMenu);
    
    setMenu (menuBar);


    for (i = 1; i <= 10; i++) {
	feldWidget[i] = new FeldWidget (this, 3, reihenfolge[i]);
	feldWidget[i]->setGeometry (30 + (i * 50), 30, 50, 70);
    };
    
    for (i = 11; i <= 20; i++) {
	feldWidget[i] = new FeldWidget (this, 4, reihenfolge[i]);
	feldWidget[i]->setGeometry (530, 50 + ((i - 10) * 50), 70, 50); 
    };	
    
    for (i = 21; i <= 30; i++) {
	feldWidget[i] = new FeldWidget (this, 1, reihenfolge[i]);
	if (i < 30) {
	    feldWidget[i]->setGeometry (530 - ((i - 20) * 50), 550, 50, 70);
	} else {
	    feldWidget[i]->setGeometry (10, 550, 70, 70);
	};
    };
    
    for (i = 31; i<= 40; i++) {
	feldWidget[i] = new FeldWidget (this, 2, reihenfolge[i]);
	if (i < 40) {
	    feldWidget[i]->setGeometry (10, 550 - ((i - 30) * 50), 70, 50);
	} else {
	    feldWidget[i]->setGeometry (10, 30, 70, 70);
	};
    };	


    wFrame = new QFrame (this);
    wFrame->setFrameStyle (QFrame::Box | QFrame::Raised);
    wFrame->setGeometry (255, 290, 100, 120);
    wFrame->hide ();
    
    wLCD1 = new QLCDNumber (1, wFrame);
    wLCD1->setGeometry (5, 5, 40, 80);
    
    wLCD2 = new QLCDNumber (1, wFrame);
    wLCD2->setGeometry (55, 5, 40, 80);
    
    wuerfeln = new QPushButton (wFrame);
    wuerfeln->setText ("Wuerfeln");
    wuerfeln->setGeometry (5, 90, 90, 20);
    connect (wuerfeln, SIGNAL (clicked ()), this, SLOT (wuerfelRollen ()));
    

    figur = QBitmap ("figur.xbm");
    
    pfigur.resize (20, 20);
    pfigur.fill (black);
    pfigur.setMask (QBitmap ("figur2.xbm"));
    
    bhaus = QBitmap ("haus.xbm");
    
    phaus.load ("haus.xpm");
    
    photel.load ("hotel.xpm");
    
    bhotel = QBitmap ("hotel.xbm");
    
    for (i = 1; i <= 4; i++) {
	switch (i) {
	    case 1: { k =  3; l =  3; f = black; break; };
	    case 2: { k = 27; l =  3; f = yellow; break; };
	    case 3: { k =  3; l = 27; f = green; break; };
	    case 4: { k = 27; l = 27; f = red; break; };
	};
	
	for (m = 1; m <= 10; m++) {
	    sp[i][m] = new QLabel (this);
	    sp[i][m]->setBackgroundColor (f);
	    sp[i][m]->setMask (figur);
	    sp[i][m]->setPixmap (pfigur);
	    if (m < 10) {
		sp[i][m]->setGeometry (30 + (m * 50) + k, 30 + l, 20, 20);
	    } else {
		sp[i][m]->setGeometry (40 + (m * 50) + k, 40 + l, 20, 20);
	    };
	    sp[i][m]->hide ();
	    
	    if (fDaten[reihenfolge[m]].typ == STRASSEN) {
		lhaus[i][m] = new QLabel (this);
		lhaus[i][m]->setBackgroundColor (green);
		lhaus[i][m]->setMask (bhaus);
		lhaus[i][m]->setPixmap (phaus);
		lhaus[i][m]->setGeometry (22 + (m * 50) + (i * 11), 80, 11, 10);
		lhaus[i][m]->hide ();
	    
		if (i == 4) {
		    lhaus[5][m] = new QLabel (this);
		    lhaus[5][m]->setBackgroundColor (red);
		    lhaus[5][m]->setMask (bhotel);
		    lhaus[5][m]->setPixmap (photel);
		    lhaus[5][m]->setGeometry (30 + 16 + (m * 50), 80, 18, 18);
		    lhaus[5][m]->hide ();
		};
	    };
	};
    
	for (m = 11; m <= 20; m++) {
	    sp[i][m] = new QLabel (this);
	    sp[i][m]->setBackgroundColor (f);
	    sp[i][m]->setMask (figur);
	    sp[i][m]->setPixmap (pfigur);
	    if (m < 20) {
		sp[i][m]->setGeometry (550 + k, 50 + ((m - 10) * 50) + l, 20, 20); 
	    } else {
		sp[i][m]->setGeometry (540 + k, 60 + ((m - 10) * 50) + l, 20, 20);
	    };
	    sp[i][m]->hide ();

	    if (fDaten[reihenfolge[m]].typ == STRASSEN) {
		lhaus[i][m] = new QLabel (this);
		lhaus[i][m]->setBackgroundColor (green);
		lhaus[i][m]->setMask (bhaus);
		lhaus[i][m]->setPixmap (phaus);
		lhaus[i][m]->setGeometry (539, 42 + ((m - 10) * 50) + (i * 11), 11, 10);
		lhaus[i][m]->hide ();
	    
		if (i == 4) {
		    lhaus[5][m] = new QLabel (this);
		    lhaus[5][m]->setBackgroundColor (red);
		    lhaus[5][m]->setMask (bhotel);
		    lhaus[5][m]->setPixmap (photel);
		    lhaus[5][m]->setGeometry (532, 50 + 16 + ((m  - 10) * 50), 18, 18);
		    lhaus[5][m]->hide ();
		};
	    };
	};	
    
	for (m = 21; m <= 30; m++) {
	    sp[i][m] = new QLabel (this);
	    sp[i][m]->setBackgroundColor (f);
	    sp[i][m]->setMask (figur);
	    sp[i][m]->setPixmap (pfigur);
	    if (m < 30) {
		sp[i][m]->setGeometry (530 - ((m - 20) * 50) + k, 570 + l, 20, 20);
	    } else {
		sp[i][m]->setGeometry (520 - ((m - 20) * 50) + k, 560 + l, 20, 20);
	    };
	    sp[i][m]->hide ();

	    if (fDaten[reihenfolge[m]].typ == STRASSEN) {
		lhaus[i][m] = new QLabel (this);
		lhaus[i][m]->setBackgroundColor (green);
		lhaus[i][m]->setMask (bhaus);
		lhaus[i][m]->setPixmap (phaus);
		lhaus[i][m]->setGeometry (522 - ((m - 20) * 50) + (i * 11), 560, 11, 10);
		lhaus[i][m]->hide ();
	    
		if (i == 4) {
		    lhaus[5][m] = new QLabel (this);
		    lhaus[5][m]->setBackgroundColor (red);
		    lhaus[5][m]->setMask (bhotel);
		    lhaus[5][m]->setPixmap (photel);
		    lhaus[5][m]->setGeometry (530 + 16 - ((m - 20) * 50), 552, 18, 18);
		    lhaus[5][m]->hide ();
		};
	    };
	};
    
	for (m = 31; m <= 40; m++) {
	    sp[i][m] = new QLabel (this);
	    sp[i][m]->setBackgroundColor (f);
	    sp[i][m]->setMask (figur);
	    sp[i][m]->setPixmap (pfigur);
	    if (m < 40) {
		sp[i][m]->setGeometry (10 + k, 550 - ((m - 30) * 50) + l, 20, 20);
	    } else {
		sp[i][m]->setGeometry (20 + k, 540 - ((m - 30) * 50) + l, 20, 20);
	    };
	    sp[i][m]->hide ();

	    if (fDaten[reihenfolge[m]].typ == STRASSEN) {
		lhaus[i][m] = new QLabel (this);
		lhaus[i][m]->setBackgroundColor (green);
		lhaus[i][m]->setMask (bhaus);
		lhaus[i][m]->setPixmap (phaus);
		lhaus[i][m]->setGeometry (60, 542 - ((m - 30) * 50) + (i * 11), 11, 10);
		lhaus[i][m]->hide ();
	    
		if (i == 4) {
		    lhaus[5][m] = new QLabel (this);
		    lhaus[5][m]->setBackgroundColor (red);
		    lhaus[5][m]->setMask (bhotel);
		    lhaus[5][m]->setPixmap (photel);
		    lhaus[5][m]->setGeometry (60, 550 + 16 - ((m - 30) * 50), 18, 18);
		    lhaus[5][m]->hide ();
		};
	    };
	};	
    };
    
    spielerWidget = new SpielerWidget (this);
    spielerWidget->setGeometry (205, 120, 200, 160);
    connect (spielerWidget, SIGNAL ( letsGo (spielerReturn) ), this, SLOT ( spielen ( spielerReturn )));
    
    for (i = 1; i <= 4; i++) {
	spielerName[i] = new QLabel (this);
	spielerName[i]->setGeometry (100, 100 + (i * 20), 60, 20);
	
	geld[i] = new QLabel (this);
	geld[i]->setGeometry (160, 100 + (i * 20), 40, 20);
	
	switch (i) {
	    case 1: { f = black; break; };
	    case 2: { f = yellow; break; };
	    case 3: { f = green; break; };
	    case 4: { f = red; break; };
	};
        sp[i][0] = new QLabel (this);
        sp[i][0]->setBackgroundColor (f);
        sp[i][0]->setMask (figur);
        sp[i][0]->setPixmap (pfigur);
	sp[i][0]->setGeometry (80, 100 + (i * 20), 20, 20);
	sp[i][0]->hide ();
    };
    
    kaufen = new QPushButton ("Kaufen", this);
    kaufen->setGeometry (90, 200, 80, 20);
    connect (kaufen, SIGNAL (clicked ()), this, SLOT (feldKaufen ()));
    kaufen->hide ();
    
    bauen = new QPushButton ("Bauen", this);
    bauen->setGeometry (90, 230, 80, 20);
    connect (bauen, SIGNAL (pressed ()), this, SLOT (feldBebauen ()));
    bauen->hide ();
    
    
    bDialog = new QDialog (this, "Bau-Dialog", TRUE);
    
    bDialog->setFixedSize (300, 200);
    bDialog->hide ();
    
    lbl = new QListBox (bDialog);
    lbl->setGeometry (10, 10, 135, 60);
    lbl->setMultiSelection (FALSE);
    
    lbm = new QListBox (bDialog);
    lbm->setGeometry (155, 10, 100, 100);
    
    QPushButton* ok = new QPushButton ("Bauen !", bDialog);
    ok->setGeometry (10, 170, 100, 20);
    connect (ok, SIGNAL (clicked ()), SLOT (bauenPressed ()));
    
    QPushButton* abbrechen = new QPushButton ("Fertig", bDialog);
    abbrechen->setGeometry (190, 170, 100, 20);
    connect (abbrechen, SIGNAL (clicked ()), bDialog, SLOT (accept ()));


    srand (QTime::currentTime().second());
};    

void MyMainWidget::spielen ( spielerReturn sR ) {
    delete spielerWidget->startBtn;
    
    for (i = 1; i <= 4; i++) {
	mySpieler = new Spieler (sR.spieler[i]);
	mySpieler->positionSetzen (sR.spieler[i], 40);
	
	spielerName[i]->setText (sR.spieler[i]);
	geld[i]->setNum (30000);
	
	sp[i][40]->show ();
    };
    
    sp[1][0]->show ();
    
    aktSpielerNummer = 0;
    wuerfel1 = 1;
    wuerfel2 = 2;

    wFrame->show ();    
};

void MyMainWidget::wuerfelRollen () {
    if (wuerfel1 != wuerfel2) {
	aktSpielerNummer++;
	if (aktSpielerNummer > 4) aktSpielerNummer = 1;
    };
    
    aktSpieler = mySpieler->name (aktSpielerNummer);
    
    aleaJactaEst ();
};

void MyMainWidget::aleaJactaEst () {
    
    for (i = 1; i <= 4; i++) {
	if (i == aktSpielerNummer) {
	    sp[i][0]->show ();
	} else {
	    sp[i][0]->hide ();
	};
    };
    for (i = 1; i <= 4; i++) {
	if (i == aktSpielerNummer) {
	    sp[i][0]->show ();
	} else {
	    sp[i][0]->hide ();
	};
    };
    
    kaufen->hide ();
    bauen->setOn (FALSE);
    bauen->hide ();
    
    wuerfel1 = rand () % 6 + 1;
    wuerfel2 = rand () % 6 + 1;
    
    wLCD1->display (wuerfel1);
    wLCD2->display (wuerfel2);
    
    i = mySpieler->positionLesen (aktSpieler);
    sp[aktSpielerNummer][i]->hide ();
    
    i += wuerfel1 + wuerfel2;
    if (i > 40) {
	mySpieler->verdienen (aktSpieler, 4000);
	i -= 40;
    };
    if (i == 40) mySpieler->verdienen (aktSpieler, 4000);
    
    sp[aktSpielerNummer][i]->show ();
    mySpieler->positionSetzen (aktSpieler, i);
    
    myFeld->miete (aktSpieler, mySpieler->positionLesen (aktSpieler));
    
    if (myFeld->kaufbar (mySpieler->positionLesen (aktSpieler))) {
	kaufen->show ();
    };
    
    if (mySpieler->darfBauen (aktSpieler, myFeld->name (mySpieler->positionLesen (aktSpieler)))) {
	bauen->show ();
    };    
    for (i = 1; i <= 4; i++) {
	geld[i]->setNum (mySpieler->bar (mySpieler->name (i)));
    };
};

void MyMainWidget::feldKaufen () {
    mySpieler->kaufen (aktSpieler);
    geld[aktSpielerNummer]->setNum (mySpieler->bar (aktSpieler));
    kaufen->hide ();
    feldWidget[mySpieler->positionLesen (aktSpieler)]->besitzer (aktSpielerNummer);
};

void MyMainWidget::weiterGehts () {
};

void MyMainWidget::quitProg () {
    exit ( 0 );
};

void MyMainWidget::feldBebauen () {
    lbl->clear ();
    lbm->clear ();
    lbm->insertItem ("0 Haeuser");
    lbm->insertItem ("1 Haus");
    lbm->insertItem ("2 Haeuser");
    lbm->insertItem ("3 Haeuser");
    lbm->insertItem ("4 Haeuser");
    bexec ();
};


void MyMainWidget::bauenPressed () {
    QString ds1, ds2;
    int     bPi;
    ds1 = lbl->text (lbl->currentItem());
    ds2 = lbm->text (lbm->currentItem());
    if (ds2 == "1 Hotel") ds2 = "5";
    ds2 = ds2.left(1);
    myFeld->bauen (ds1, ds2.toInt ());
    
    geld[aktSpielerNummer]->setNum (mySpieler->bar (aktSpieler));
    
    lhaus[5][myFeld->ID2 (ds1)]->hide ();
    
    for (bPi = 1; bPi <= 4; bPi++) {
	if (bPi <= myFeld->gebaeude (ds1)) {
	    lhaus[bPi][myFeld->ID2 (ds1)]->show ();
	} else {
	    lhaus[bPi][myFeld->ID2 (ds1)]->hide ();
	};
    };
    
    if (ds2 == "5") {
	for (bPi = 1; bPi <= 4; bPi++) {
	    lhaus[bPi][myFeld->ID2 (ds1)]->hide ();
	};
	lhaus[5][myFeld->ID2 (ds1)]->show ();
    };
};

int MyMainWidget::bexec () {
    QString s1, s2, s3;
    
    switch (myFeld->farbe(myFeld->name(mySpieler->positionLesen (aktSpieler)))) {
	case 1: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[1].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[2].name))) {
			    s1 = fDaten[1].name;
			    s2 = fDaten[2].name;
			    s3 = "(none)";
		    };
		    break;
		};
	case 2: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[3].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[4].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[5].name))) {
			    s1 = fDaten[3].name;
			    s2 = fDaten[4].name;
			    s3 = fDaten[5].name;
		    };
		    break;
		};
	case 3: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[6].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[7].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[8].name))) {
			    s1 = fDaten[6].name;
			    s2 = fDaten[7].name;
			    s3 = fDaten[8].name;
		    };
		    break;
		};
	case 4: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[9].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[10].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[11].name))) {
			    s1 = fDaten[9].name;
			    s2 = fDaten[10].name;
			    s3 = fDaten[11].name;
		    };
		    break;
		 };
	case 5: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[12].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[13].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[14].name))) {
			    s1 = fDaten[12].name;
			    s2 = fDaten[13].name;
			    s3 = fDaten[14].name;
		    };
		    break;
		 };
	case 6: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[15].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[16].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[17].name))) {
			    s1 = fDaten[15].name;
			    s2 = fDaten[16].name;
			    s3 = fDaten[17].name;
		    };
		    break;
		 };
	case 7: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[18].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[19].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[20].name))) {
			    s1 = fDaten[18].name;
			    s2 = fDaten[19].name;
			    s3 = fDaten[20].name;
		    };
		    break;
		 };
	case 8: {
		    if ((mySpieler->besitzt (aktSpieler, fDaten[21].name)) &&
			(mySpieler->besitzt (aktSpieler, fDaten[22].name))) {
			    s1 = fDaten[21].name;
			    s2 = fDaten[22].name;
			    s3 = "(none)";
		    };
		    break;
		 };
	 default: {
	             s1 = "Verdammte";
		     s2 = "scheisse";
		     s3 = "(none)";
		     break;
		  };
    };
    
    
    lbl->insertItem (s1);
    lbl->insertItem (s2);
    if (s3 != "(none)") lbl->insertItem (s3);
    
    if (myFeld->gebaeude (s1) == 4) lbm->insertItem ("1 Hotel");
    
    connect (lbl, SIGNAL (highlighted (int)), this, SLOT (bauenHighlighted (int)));
    
    return bDialog->exec ();
};    

void MyMainWidget::bauenHighlighted (int Nr) {
    lbm->setCurrentItem (myFeld->gebaeude (lbl->text (lbl->currentItem ())));
};