#ifndef SCORE_H
#define SCORE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qstring.h>
#include <qpoint.h>
#include <qrect.h>
#include <qfile.h>

#if (KDE_VERSION_MAJOR >= 1 && KDE_VERSION_MINOR >= 1)
#include <qdatetime.h>
#else
#include <qdatetm.h>
#endif

#include "painter.h"
#include "bitfont.h"

#define maxPlayer 1
#define minPlayerNameLength 3

class Score : public QWidget
{
    Q_OBJECT
public:
    Score (QWidget *parent=0, const char *name=0, Bitfont *font=0);
    ~Score();

public slots:
    void set(int score);
    void set(int score, int player);
    void setScore(int level, int player);
    void setFont(Bitfont *font=0);

    void initKeys();
    void initTiming();

    void pause();

private slots:
    void read();
    void write();
    void end();

signals:
    void toggleNew();
    void forcedHallOfFame(bool);

protected:
    void timerEvent( QTimerEvent * );
    void paintEvent( QPaintEvent * );
    void keyPressEvent( QKeyEvent * );

private:
    Bitfont *bitfont;

    QRect rect(int col, float row, QString str, int align = AlignCenter);
    int x(int col);
    int y(float row);

    QString formatDate(QDate date);

    int cursorBlinkMS;
    int hallOfFameMS;

    int afterPauseMS;

    bool paused;

    uint UpKey;
    uint DownKey;
    uint RightKey;
    uint LeftKey;

    int lastScore;
    int lastPlayer;
    int HighScore;
    int playerScore[maxPlayer];
    QString playerName[maxPlayer];

    struct {
        int x;
        int y;
        QString chr;
        bool on;
    } cursor;

    bool scrollRepeat;

    struct {
        int points;
        int levels;
        QTime duration;
        QDateTime moment;
        char *name;
    } hallOfFame[10];

    QFile file;
};

#endif // SCORE_H

