/***************************************************************************
                          kpicframer.cpp  -  description
                             -------------------
    begin                : Sat Mar 25 17:47:12 MET 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpicframer.h"
#include "kscore.h"
#include <time.h>

kpicframer::kpicframer(QWidget *parent, const char *name) : KTopLevelWidget()
{
	setFixedSize(520,470);
  setCaption("KPicFramer");
	kacc = new KAccel( this );
	KStdAccel stdacc; // Access to standard accelerators
	/* KKeyCode initialization */
	kacc->insertItem(i18n("Quit"), "Quit", stdacc.quit());
	kacc->insertItem(i18n("New game"), "New", "F2");
	kacc->insertItem(i18n("Help"), "Help", stdacc.help());
	kacc->insertItem(i18n("Back"), "Back", "CTRL+B");
	
	/* connections */
	kacc->connectItem("Quit", this, SLOT(quitGame()));
	kacc->connectItem("New", this, SLOT(initGame()));
	kacc->connectItem("Back", this, SLOT(undo()));


	srand(time(NULL));
	phase=0;
	
	scoreTimer = new QTimer(this);
	connect( scoreTimer, SIGNAL(timeout()), SLOT(scoreTimerEvent()) );

	setBackgroundColor(QColor("darkgreen"));
	initMenu();
	initToolbar();
	initPlayField();
	initGame();
	readConfig();
}

kpicframer::~kpicframer()
{
	delete kacc;
	delete scoreTimer;
}

void kpicframer::initMenu()
{
	QPopupMenu *game = new QPopupMenu();
	game->insertItem(i18n("&New Game"), this, SLOT(initGame()), Key_F2);
	game->insertItem(i18n("S&tatistic"), this, SLOT(showStatistic()));
	game->insertSeparator();
	game->insertItem(i18n("&Quit"),this, SLOT(quitGame()),CTRL+Key_Q);

//	QPopupMenu *options = new QPopupMenu();
//	options->insertItem(i18n("&Options"), this, SLOT(changeOptions()));
	
	QPopupMenu *help = kapp->getHelpMenu(true, QString("kpicframer")
					 + " " + KPICFRAMER_VERSION + " released " + KPICFRAMER_RELEASE_DATE
           + "\n \n" + i18n("by") + " Norbert Andres"
           + " (nandres@gmx.de)\n\n"
					 + i18n("\nSuggestions, bug reports etc. are welcome")
					     );

	KMenuBar *menu = new KMenuBar(this);
	menu->insertItem(i18n("&Game"),game);
//	menu->insertItem(i18n("&Options"), options);
	menu->insertItem(i18n("&Help"), help);

	setMenu(menu);
}

void kpicframer::initToolbar()
{
	status = new KStatusBar(this,0);
	status->insertItem(i18n("000"),2);
	status->insertItem(i18n("Score: "),1);
	status->insertItem(i18n("Ready"),0);
	status->setInsertOrder( KStatusBar::RightToLeft );
	status->setAlignment(0,AlignLeft);
	setStatusBar(status);
	status->changeItem(i18n("   "),2);
}

void kpicframer::initPlayField()
{
	stapel = new KCard(this,0);
	stapel->enableHighlightning(false);
	stapel->setPos(20,90);
	stapel->setCardNumber(-1);
	stapel->show();
	connect (stapel, SIGNAL(clicked(KCard*)), this, SLOT(nextCard(KCard*)));

	activeCard = new KCard(this,0);
	activeCard->setPos(20,290);
	activeCard->enableMarking(false);
	activeCard->setCardNumber(-1);
	activeCard->show();
	connect (activeCard, SIGNAL(clicked(KCard*)), this, SLOT(nextCard(KCard*)));

	int i=0;
	for (int y=40;y<=340;y+=100)
	{
		for (int x=150;x<=384;x+=78)
		{
			cards[i] = new KCard(this,0);
			connect (cards[i], SIGNAL(clicked(KCard*)), this, SLOT(cardClicked(KCard*)));
			cards[i]->setPos(x,y);
			cards[i]->show();
			i++;
		}
	}
	lCounter = new QLabel("52", this, 0 ,0);
	lCounter->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
	lCounter->setLineWidth(1);
	lCounter->setMidLineWidth(3);
	lCounter->setAutoResize(false);
	lCounter->setAlignment(AlignCenter);
	lCounter->setGeometry(22,194,72,20);
	lCounter->setBackgroundColor(QColor("yellow"));
	lCounter->show();
	wonGames = lostGames = stoppedGames = highScore = 0;
}

void kpicframer::initGame()
{
	// Kartenreihenfolge bestimmen
  if (phase!=0)
	{
		if (!stopCurrentGame())
			return;
	}
	lastField=-1;
	cStack[0]=-1;
	for (int n=1;n<52;n++)
		cStack[n]=n;
	int a = 0;
	int b = 0;
	for (int m=1;m<208;m++)
	{
		a = rand()%51;
		b = rand()%51;
		while (a==b)
			b = rand()%51;
    a++;b++;
		int temp = cStack[a];
		cStack[a] = cStack[b];
		cStack[b] = temp;
		if (m%4 == 0)
			lCounter->setNum(m);
	}

	// Alle Felder leeren
	mcount=0;
	mindex1=mindex2=-1;
	cardIndex=52;
	score=0;
	phase=1;
	for (int i=0; i<16; i++)
		cards[i]->setCardNumber(empty);
	status->changeItem( i18n("Good luck!"), 0 );
	status->changeItem( i18n("000"),2);

	// Erste Karte aufdecken
	newCard();
	stapel->setCardNumber(back);
	// Score-Timer starten: alle 4 Sekunden wird 1 Punkt vom Score abgezogen
	if (scoreTimer->isActive())
		scoreTimer->stop();
	scoreTimer->start(4000);	
}

void kpicframer::scoreTimerEvent()
{	
	changeScore(-1);
}

bool kpicframer::stopCurrentGame()
{
		if (emptyFieldsCount()==16)
			return true;
  	QMessageBox mb( "KPicFramer",i18n("Do you want to stop the current game?"), QMessageBox::Warning,
			QMessageBox::Yes | QMessageBox::Default, QMessageBox::No, QMessageBox::Cancel,this);
		mb.setButtonText( QMessageBox::Yes, i18n("Yes") );
		mb.setButtonText( QMessageBox::No, i18n("No") );
		switch( mb.exec() )
		{
			case QMessageBox::Yes:
				stoppedGames++;
				if (scoreTimer->isActive())
					scoreTimer->stop();
				return true;
				break;
			case QMessageBox::No:
				return false;
				break;
			default:
				return false;
				break;
		}
}

bool kpicframer::queryClose()
{
	if (phase!=0)
	{
		if (!stopCurrentGame())
			return false;
	}
	return true;
}

void kpicframer::quitGame()
{
	if (phase!=0)
	{
		if (!stopCurrentGame())
			return;
	}
	saveConfig();
	kapp->quit();
}

void kpicframer::readConfig()
{
	KConfig *config = kapp->getConfig();
	config->setGroup("Statistic");
	wonGames = config->readNumEntry("wonGames",0);
	lostGames = config->readNumEntry("lostGames",0);
	stoppedGames = config->readNumEntry("stoppedGames",0);
	highScore = config->readNumEntry("HighScore",0);
}

void kpicframer::saveConfig()
{
	KConfig *config = kapp->getConfig();
	config->setGroup("Statistic");
	config->writeEntry("wonGames",wonGames);
	config->writeEntry("lostGames",lostGames);
	config->writeEntry("stoppedGames",stoppedGames);
	config->writeEntry("HighScore",highScore);
}

void kpicframer::showStatistic()
{
	KScore dlg(this, wonGames, lostGames, stoppedGames, highScore);
	wonGames = dlg.newWonG;
	lostGames= dlg.newLostG;
	stoppedGames=dlg.newStoppedG;
	highScore= dlg.newHScore;
}

void kpicframer::changeOptions()
{
	// Farben	
	// Rckseite
	// Einstellungen (Positionen, Settings, Statistic) beim Beenden speichern
}

int kpicframer::getFieldIndex(KCard *card)
{
	for (int i=0;i<16;i++)
	{
		if (cards[i]==card)
			return i;
	}
	return -1;
}

bool kpicframer::cardTest(KCard *card, int actCardNumber)
{
	int index = getFieldIndex(card);

	if ( (actCardNumber>=spadesJack) && (actCardNumber<=clubJack) ) // beschrnkte Karten (1)
	{
		if ( (index!=1) && (index!=2) && (index!=13) && (index!=14) )
		{
			// darf nicht markiert werden
			cards[1]->startBlink(3);
			cards[2]->startBlink(3);
			cards[13]->startBlink(3);
			cards[14]->startBlink(3);
			status->changeItem( i18n("Illegal move - Place the card on one of the blinking fields!"), 0 );
			return false;
		}
	}
	if ( (actCardNumber>=spadesQueen) && (actCardNumber<=clubQueen) ) // beschrnkte Karten (2)
	{
		if ( (card!=cards[4]) && (card!=cards[7]) && (card!=cards[8]) && (card!=cards[11]) )
		{
			// darf nicht markiert werden
			cards[4]->startBlink(3);
			cards[7]->startBlink(3);
			cards[8]->startBlink(3);
			cards[11]->startBlink(3);
			status->changeItem( i18n("Illegal move - Place the card on one of the blinking fields!"), 0 );
			return false;
		}
	}
	if ( (actCardNumber>=spadesKing) && (actCardNumber<=clubKing) ) // beschrnkte Karten (3)
	{
		if ( (card!=cards[0]) && (card!=cards[3]) && (card!=cards[12]) && (card!=cards[15]) )
		{
			// darf nicht markiert werden
			cards[0]->startBlink(3);
			cards[3]->startBlink(3);
			cards[12]->startBlink(3);
			cards[15]->startBlink(3);
			status->changeItem( i18n("Illegal move - Place the card on one of the blinking fields!"), 0 );
			return false;
		}
	}
	return true;
}

bool kpicframer::picFrameReady()
{
	if ((activeCard->getCardNumber()<spadesJack) || (activeCard->getCardNumber()>clubKing))
		return false;
	for (int i=1;i<=cardIndex;i++)
	{
		if ((cStack[i]>=spadesJack) && (cStack[i]<=clubKing))
			return false;
	}
	return true;
}

int kpicframer::getSumme()
{
	int val1 = cards[mindex1]->getValue();
	int val2 = cards[mindex2]->getValue();
	return val1+val2;	
}

bool kpicframer::layDownCard(KCard* card)
{
		// Ist der Platz frei?
		if (card->getCardNumber()!=-1)
			return false;
		int actCardNumber = activeCard->getCardNumber();
		// Test, ob diese Karte dahin darf:
		if (!cardTest(card, actCardNumber))
				return false;
		// Karte ablegen
		card->setCardNumber(actCardNumber);	
		changeScore(actCardNumber);
		// Ist der PictureFrame gelegt?
		if (picFrameReady())
		{
			won();
			return true;
		}
		// Neue Karte aufdecken
		lastField = getFieldIndex(card);
		newCard();
		return true;
}

bool kpicframer::pickUpCard(KCard* card)
{
	int value = card->getCardNumber();
	int index = getFieldIndex(card);
	lastField=-1;

	if (!card->isMarked())
	{
		if (mcount>1)
			return false;
		// Darf die Karte markiert werden?
		if ( (value>=spadesJack) && (value<=clubKing) )
			return false;
		// Markiere Karte
		card->markField(true);
		card->update();
		mcount++;
		// Speicher Index der neu markierten Karte
		switch(mcount)
		{
			case 1: mindex1=index;
							break;
			case 2: mindex2=index;
							break;
		}
	}
  else
	{
		// Markierung aufheben
		card->markField(false);
		mcount--;
		// Index lschen
		switch(mcount)
		{
			case 0: mindex1=-1;
							break;
			case 1: mindex2=-1;
							break;
		}
	}
	// Wenn mehr als eine Karte markiert ist, wird Summe berechnet
	if (mcount>0)
	{
		switch(mcount)
		{
    	case 1:	if ((cards[mindex1]->getCardNumber()>=spades10) && (cards[mindex1]->getCardNumber()<=club10))
							{
										cards[mindex1]->setCardNumber(-1);
										cards[mindex1]->markField(false);
										mcount--;
										mindex1=-1;
							}
							break;
			case 2:	if (getSumme()==10)
							{
									cards[mindex1]->setCardNumber(-1);
									cards[mindex1]->markField(false);
									mcount--;
									cards[mindex2]->setCardNumber(-1);
									cards[mindex2]->markField(false);
									mcount--;
									mindex1=-1;mindex2=-1;
							}
							else
							{		// nur Markierung aufheben
									cards[mindex1]->markField(false);
									mcount--;
									cards[mindex2]->markField(false);
									mcount--;
									mindex1=-1;mindex2=-1;								
							}
		}
	}
	if (!pickupPossible())
	{
		nextCard(card);
		if (phase!=0)
			phase=1;
	}
	return true;
}

void kpicframer::cardClicked(KCard* card)
{
	if (phase==0)
		return;
	if ((card->getCardNumber()==-1) && (phase==2))
	{
		nextCard(card);
		return;
	}
  for (int i=0;i<16;i++)
		cards[i]->stopBlink();
	int value = card->getCardNumber();
	if (value==-1)
		phase=1;
	if (emptyFieldsCount()==0)
		phase=2;
	switch(phase)
	{
		case 1:	layDownCard(card);
						break;
		case 2: pickUpCard(card);
						break;
	}
}

void kpicframer::changeScore(int number)
{
  QString str;
	int diff;
	if (number>0)
	{
		diff = 5;
		if ((number>=spadesJack) && (number<=clubKing))
			diff=10;		
	}
	else
	{
		diff=number;
	}
	score+=diff;
	str.setNum(score);
	status->changeItem(str,2);
}

int	kpicframer::emptyFieldsCount()
{
	int count = 0;
	for (int i=0;i<16;i++)
	{
		if (cards[i]->getCardNumber()==-1)
			count++;
	}	
	return count;
}

bool kpicframer::gameLost()
{
	if (emptyFieldsCount()==0)
		return false;
	int actCardNumber = activeCard->getCardNumber();
	if ( (actCardNumber>=spadesJack) && (actCardNumber<=clubJack) ) // beschrnkte Karten (1)
	{
      if ( (cards[1]->getCardNumber()!=-1) && (cards[2]->getCardNumber()!=-1) &&
					 (cards[13]->getCardNumber()!=-1) && (cards[14]->getCardNumber()!=-1) )
			return true;
	}
	if ( (actCardNumber>=spadesQueen) && (actCardNumber<=clubQueen) ) // beschrnkte Karten (2)
	{
       if ( (cards[4]->getCardNumber()!=-1) && (cards[7]->getCardNumber()!=-1) &&
					 (cards[8]->getCardNumber()!=-1) && (cards[11]->getCardNumber()!=-1) )
				return true;
	}
	if ( (actCardNumber>=spadesKing) && (actCardNumber<=clubKing) ) // beschrnkte Karten (3)
	{	
      if ( (cards[0]->getCardNumber()!=-1) && (cards[3]->getCardNumber()!=-1) &&
					 (cards[12]->getCardNumber()!=-1) && (cards[15]->getCardNumber()!=-1) )
			return true;
	}
	return false;
}

bool kpicframer::pickupPossible()
{
	// Erstens: Test ob eine Karte den Wert 10 hat
	for (int i=0;i<16;i++)
	{
		if ((cards[i]->getCardNumber()>=spades10) && (cards[i]->getCardNumber()<=club10))
			return true;
	}
	// Zweitens: zu jeder Karte <=club10 && >=spadesAce eine passende suchen
	for (int j=0;j<16;j++)
	{
		if ((cards[j]->getCardNumber()>club9) && (cards[j]->getCardNumber()<spadesAce))
			continue;
		int v1 = cards[j]->getValue();
		for (int n=j+1;n<16;n++)
		{
    	if ((cards[n]->getCardNumber()>club9) && (cards[n]->getCardNumber()<spadesAce))
				continue;
			int v2 = cards[n]->getValue();
			if (v1 + v2 == 10)
				return true;
		}
	}
	return false;
}

void kpicframer::newCard()
{	
	status->changeItem( i18n("Good luck!"), 0 );
	if (cardIndex==0)
	{
		won();
		return;
	}

  int ec = emptyFieldsCount();
	if (ec==0)
	{
		if (phase!=0)
			phase=2;
		activeCard->setCardNumber(empty);
		if (!pickupPossible())
		{
			lost();			
			return;
		}
			
		return;
	}
	if (cardIndex>0)
	{
		activeCard->setCardNumber(cStack[cardIndex]);
		cardIndex--;
		lCounter->setNum(cardIndex);
	}
	if (cardIndex==0)
		stapel->setCardNumber(empty);
	if (gameLost())
	{
		lost();
		return;
	}
}

void kpicframer::lost()
{
		phase=0;
		status->changeItem( i18n("You've lost!"),0);
		lostGames++;
		if (scoreTimer->isActive())
			scoreTimer->stop();
		checkScore();
		saveConfig();
  	QMessageBox mb( "KPicFramer",i18n("You've lost! Do you want to play again?"), QMessageBox::Warning,
			QMessageBox::Yes | QMessageBox::Default, QMessageBox::No, QMessageBox::Cancel,this);
		mb.setButtonText( QMessageBox::Yes, i18n("Yes") );
		mb.setButtonText( QMessageBox::No,  i18n("Quit"));
		mb.setButtonText( QMessageBox::Cancel,  i18n("Cancel"));
		switch( mb.exec() )
		{
			case QMessageBox::Yes:
			{
				initGame();
				return;
				break;
			}
      case QMessageBox::No:
			{
				quitGame();
				return;
				break;
			}
			case QMessageBox::Cancel:
			{
				return;
			}
		}
}

void kpicframer::won()
{
		phase=0;
		activeCard->setCardNumber(empty);
		status->changeItem( i18n("You've won!"),0);
		if (scoreTimer->isActive())
			scoreTimer->stop();
		score+=cardIndex;
  	QString str;
		str.setNum(score);
		status->changeItem(str,2);
		wonGames++;
		checkScore();
		saveConfig();
  	QMessageBox mb( "KPicFramer",i18n("You've won! Do you want to play again?"), QMessageBox::Warning,
			QMessageBox::Yes | QMessageBox::Default, QMessageBox::No, QMessageBox::Cancel,this);
		mb.setButtonText( QMessageBox::Yes, i18n("Yes") );
		mb.setButtonText( QMessageBox::No,  i18n("Quit"));
		mb.setButtonText( QMessageBox::Cancel,  i18n("Cancel"));
		switch( mb.exec() )
		{
			case QMessageBox::Yes:
			{
				initGame();
				return;
				break;
			}
      case QMessageBox::No:
			{
				quitGame();
				return;
				break;
			}
			case QMessageBox::Cancel:
			{
				return;
			}
		}
}

void kpicframer::nextCard(KCard*)
{
	if (phase!=2)
		return;
	phase=1;
	if (cardIndex>0)
	{
		activeCard->setCardNumber(cStack[cardIndex]);
		cardIndex--;
		lCounter->setNum(cardIndex);
	}
	if (cardIndex==0)
		stapel->setCardNumber(empty);
	if (gameLost())
	{
		lost();
		return;
	}
}

void kpicframer::undo()
{
	if (lastField==-1)
		return;
	cardIndex++;
	activeCard->setCardNumber(cards[lastField]->getCardNumber());
	lCounter->setNum(cardIndex);
	cards[lastField]->setCardNumber(-1);
	if ((activeCard->getCardNumber()>=spadesJack) && (activeCard->getCardNumber()<=clubKing))
		changeScore(-10);
	else
		changeScore(-5);
	if (phase==0)
	{
		phase=1;
		lostGames--;
	}
	lastField=-1;
}

void kpicframer::checkScore()
{
	if (highScore<score)
		highScore=score;
}