
// -*- c++ -*-

#ifndef PLAYFIELD_H
#define PLAYFIELD_H

#include <kcontainer.h>
#include <qmlined.h>
#include <qvector.h>
#include <qpushbutton.h>
#include "constants.h"
#include "pbutton.h"

typedef QVector<PipeButton> PipeField;

class PlayField : public QWidget
{
  Q_OBJECT

public:
  enum Fluid { Oil, Water, Acid };
  PlayField(QWidget *parent, const char *name);
  ~PlayField();

  void setFluid(Fluid x);
  

 public slots:
  void linkToBuild(PipeButton::LinkType);
  void gameStarted();
  void flowEvent();
  void linkFilled(PipeButton::Direction d);
 private slots:
    void buttonClicked();
  void brokenPipe();
signals:
  void requireLink();
  void gameOver();
  void scoreChanged(int);

private:
  bool inGame;
  PipeField *playField;
  PipeButton::LinkType nextLink;
  
  // in welche Richtung fliesst es zur Zeit?
  PipeButton::Direction flowDir;

  // in welchem "Planquadrat" liegt das zur Zeit durchflossene Link?
  int flowArea;
  QColor fluidCol;

  void closeEvent(QCloseEvent *e);
  int exit();
};

#endif // PLAYFIELD.H













