#include <qmsgbox.h>
#include <qstring.h>
#include <stdlib.h>                             // rand() function
#include <qdatetime.h>                          // seed for rand()
#include "status.h"
#include "dialogs.h"

// Define generic command codes
// Define status item codes


Status::Status(QWidget *parent, const char *name): QWidget(parent, name)
{

	/* configuration & highscore initialisation */
	kconf = kapp->getConfig();
	isConfigWritable =
		(kapp->getConfigState()==KApplication::APPCONFIG_READWRITE);
	
	/* if the entries do not exist : create them */
	kconf->setGroup(HS_GRP);
	QString str1, str2;
	for (int i=0; i<NB_HS; i++) {
		str1.sprintf("%s%i", HS_NAME_KEY, i);
		if ( !kconf->hasKey(str1) )
		    kconf->writeEntry(str1, i18n("Anonymous"));
		str2.sprintf("%s%i", HS_SCORE_KEY, i);    
		if ( !kconf->hasKey(str2) )
			kconf->writeEntry(str2, 0);
	}     

  inGame=false;

  timeLCD=new QLCDNumber(2,this,"time");
  timeLCD->setGeometry(5,15,SQUAREDIM,SQUAREDIM);
  timeLCD->show();

  const int prevOffset=75;

  for(int j=0;j<5;j++)
    {
      preview[j]=new PipeButton(this);
      preview[j]->setGeometry(5,prevOffset+15+SQUAREDIM*j,SQUAREDIM,SQUAREDIM);
      preview[j]->setLink(PipeButton::Empty);
      preview[j]->show();
      preview[j]->setEnabled(false);
    }
    preview[0]->setGeometry(5,prevOffset,SQUAREDIM,SQUAREDIM);
    connect( preview[0], SIGNAL(clicked()), SLOT(buttonClicked()));
    preview[0]->setEnabled(true);
  

    scoreLCD=new QLCDNumber(5,this);
    scoreLCD->setGeometry(0,prevOffset+30+5*SQUAREDIM,SQUAREDIM+10,30);
    

 QTime t = QTime::currentTime();             // set random seed
 srand( t.hour()*12+t.minute()*60+t.second()*60 );

 show();
}

Status::~Status()
{
  delete(timeLCD);
  delete(scoreLCD);
  for(int i=0;i<5;i++) delete(preview[i]);
}

void Status::linkRequired()
{
  if(!inGame) return;

  for(int i=0;i<4;i++) preview[i]->setLink(preview[i+1]->getLink());
  preview[4]->setLink(randLink());
  emit nextLink(preview[0]->getLink());
}

void Status::buttonClicked()
{
  if(scoreLCD->intValue()>25)
    {
      scoreChanged(-25);
      linkRequired();
    } // else beep() <-- Wie macht man das bei KDE?
}

void Status::gameStarted()
{
  inGame=true;
  for(int i=0;i<5;i++) preview[i]->setLink(randLink());
  scoreLCD->display(0);
  emit nextLink(preview[0]->getLink());
}  

PipeButton::LinkType Status::randLink()
{
  PipeButton::LinkType lavail[]={PipeButton::Cross,PipeButton::Right,
			       PipeButton::Down, PipeButton::Upright,
                               PipeButton::Downright, PipeButton::Leftdown,
                               PipeButton::Leftup, PipeButton::Bomb};

  // Modulo two times to make bomb appear less often.
  return lavail[(rand()%15)%8];
}


void Status::scoreChanged(int change)
{
 scoreLCD->display(scoreLCD->intValue()+change); 
}

void Status::closeEvent(QCloseEvent *e)
{
  e->accept();
}

void Status::gameOver()
{
  for(int i=0;i<5;i++) preview[i]->setLink(PipeButton::Empty);
  inGame=false;

  if(isConfigWritable) 
    {
      WHighScores hs(false,scoreLCD->intValue(),this);
      kapp->getConfig()->sync();
    }
}

void Status::showHighscores()
{
  if(isConfigWritable) WHighScores hs(true,-1,this);
  else QMessageBox::warning(0,0,"Error accessing high score file.");
}





