#ifndef _PLAYERBOARD_H_
#define _PLAYERBOARD_H_

#include <qwidget.h>
#include <ksock.h>
#include <qmultilinedit.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <kpixmap.h>
#include "casewidget.h"
#include "resource.h"
#include "intpuis.h"

struct BoardOptionsStruct
{
	int	NumCols, NumRows, NumPuis;
	int	Level;
	bool	UseBackgroundPixmap;
	QString	BackgroundPixmap;
	QColor	BackgroundColor;
	QString	Host;
	int	Port;
	QString	ServerProgram;
	bool	LocalMode;
	QString	SocketName;
};

struct Player
{
	Player() : PlayerNumber(-1), Socket(0), Table(new InternalPuissance(7,6,4)) {}
	~Player() { delete Table;}
	int			PlayerNumber;
	KSocket			*Socket;
	InternalPuissance	*Table;
};

class PlayerBoard : public QWidget
{
	Q_OBJECT;

public:
	PlayerBoard(BoardOptionsStruct *o, QWidget *parent = 0, const char *name = 0);
	~PlayerBoard();

	void connectToServer();
	void disconnect();
	void setMessageWindow(QMultiLineEdit *edit) { MessageWindow = edit;}
	void restart();
	void messageToServer(const char *msg);
	bool connected() { return (HumanPlayer->Socket != 0);}
	void updateBoard();
	void createComputerPlayer();
	void playAgainstComputer();
	void hint();
	void undo();

protected slots:
	void slotReadEvent(KSocket*);
	void slotWriteEvent(KSocket*);
	void slotCloseEvent(KSocket*);
	void columnPressed(int col);
	void slotTimer();

protected:
	void message(const char *msg);
	void dispatch(QStrList& cmd);
	void dispatchComputer(QStrList& cmd);
	void sendMessage(KSocket *sock, const char *msg, bool deferred = true);
	void serverClose();
	void serverRefuse();
	void serverAccept();
	void serverPlayer(int);
	void serverDimensions(int,int);
	void serverRestart();
	void serverTurn(int player);
	void serverNoStart();
	void serverPlay(int player, int col, int index);
	void serverNoPlay();
	void serverWon(QStrList& list);
	void serverQuit(int player);
	void serverNumberOfPlayers(int n);
	void serverMessage(const char *msg);
	void serverPuissance(int np);
	void serverUndo();

	void clearDisplay();
	void initDisplay();
	void resizeEvent(QResizeEvent *e);
	void reloadIcons(int size);
	void setCanPlay(bool set);
	void dropInColumn(int col, int index, int state);

protected:
	CaseWidget	*Cases;
	Player		*HumanPlayer, *ComputerPlayer;
	QMultiLineEdit	*MessageWindow;
	QButtonGroup	*ButtonGroup;
	QPushButton	*Buttons[20];
	BoardOptionsStruct	*BoardOptions;
	QPixmap		Pix[2];
	bool		CanPlay;
	QString		MessageToSend;
	QArray<int>	WinnerCases;
	int		Winner;
	QTimer		WinTimer;
};

#endif
