#include "viewoptions.h"
#include <kapp.h>
#include <qpixmap.h>

ViewOptions::ViewOptions(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	UsePixmap = new QCheckBox(i18n("Use background pixmap"),this);
	Pixmap = new QComboBox(this);
	Color = new KColorButton(this);

	PixmapLabel = new QLabel(i18n("Background pixmap"),this);
	ColorLabel = new QLabel(i18n("Background color"),this);
	PixmapPreview = new QLabel(this);

	connect(Pixmap,SIGNAL(activated(int)),SLOT(pixmapChanged(int)));
}

ViewOptions::~ViewOptions()
{
}

void ViewOptions::resizeEvent(QResizeEvent *e)
{
	UsePixmap->setGeometry(10,10,width()-20,25);
	int	size1 = (width()-30)/2;
	ColorLabel->setGeometry(10,55,size1,25);
	Color->setGeometry(10,85,size1/2,30);
	PixmapLabel->setGeometry(20+size1,55,size1,25);
	Pixmap->setGeometry(20+size1,85,size1,25);
	PixmapPreview->setGeometry(20+size1,115,size1,height()-125);
}

void ViewOptions::pixmapChanged(int index)
{
	QString		path = (KApplication::kde_wallpaperdir() + "/" + Pixmap->text(index));
	PixmapPreview->setPixmap(QPixmap(path.data()));
}
